// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef HashTable_INCLUDED
#define HashTable_INCLUDED 1

#include <stddef.h>
#include "OwnerTable.H"
#include "Hash.H"
#include "Boolean.H"
#include "HashTableItemBase.H"

template<class K, class V>
struct HashTableItem : public HashTableItemBase<K> {
  HashTableItem(const K &k, const V &v);
  V value;
};

template<class K, class V> class HashTableIter;

template<class K, class V>
class HashTable {
public:
  HashTable();
  HashTable(const HashTable<K, V> &); // undefined
  void operator=(const HashTable<K, V> &); // undefined
  void insert(const K &key, const V &value, Boolean replace = 1);
  const V *lookup(const K &key) const {
    HashTableItem<K, V> *tem = (HashTableItem<K, V> *)table_.lookup(key);
    return tem ? &tem->value : 0;
  }
private:
  OwnerTable<HashTableItemBase<K>, K, Hash, HashTableKeyFunction<K> > table_;
friend class HashTableIter<K,V>;
};

template<class K, class V>
class HashTableIter {
public:
  HashTableIter(const HashTable<K, V> &table) : iter_(table.table_) { }
  Boolean next(const K *&key, const V *&value) {
    HashTableItem<K, V> *p = (HashTableItem<K, V> *)iter_.next();
    if (p) {
      key = &p->key;
      value = &p->value;
      return 1;
    }
    else
      return 0;
  }
private:
  OwnerTableIter<HashTableItemBase<K>, K, Hash, HashTableKeyFunction<K> > iter_;
};

#ifdef DEFINE_TEMPLATES
#include "HashTable.C"
#endif

#endif /* not HashTable_INCLUDED */
