// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef HashTableItemBase_INCLUDED
#define HashTableItemBase_INCLUDED 1

// All hash tables with the same type of key share object code.
// The cost of this is a virtual dtor in HashTableItemBase.

template<class K>
struct HashTableItemBase {
  HashTableItemBase(const K &k);
  virtual ~HashTableItemBase();
  K key;
};

template<class K>
struct HashTableKeyFunction {
  static inline const K &key(const HashTableItemBase<K> &obj) {
    return obj.key;
  }
};

#ifdef DEFINE_TEMPLATES
#include "HashTableItemBase.C"
#endif

#endif /* not HashTableItemBase_INCLUDED */
