// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Id_INCLUDED
#define Id_INCLUDED 1

#include "Named.H"
#include "Location.H"

class Id : public Named {
public:
  Id(const CString &);
  void define(const Location &);
  void reference(const Location &);
  Boolean defined() const;
  Boolean referenced() const;
  const Location &defLocation() const;
  const Location &refLocation() const;
private:
  Location defLocation_;
  Location refLocation_;
};

inline
Id::Id(const CString &name)
: Named(name)
{
}

inline
void Id::define(const Location &loc)
{
  defLocation_ = loc;
}

inline
void Id::reference(const Location &loc)
{
  refLocation_ = loc;
}

inline
Boolean Id::defined() const
{
  return !defLocation_.origin().isNull();
}

inline
Boolean Id::referenced() const
{
  return !refLocation_.origin().isNull();
}

inline
const Location &Id::defLocation() const
{
  return defLocation_;
}

inline
const Location &Id::refLocation() const
{
  return refLocation_;
}

#endif /* not Id_INCLUDED */
