// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef InputContext_INCLUDED
#define InputContext_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Location.H"

class MessageArg;

// This is used by the entity manager and link process to report errors.

class InputContext {
public:
  enum {
    // Severity values must match corresponding values in InputContext.
    info = 0,
    warning = 01,
    quantityError = 02,
    error = 03,
    severityMask = 03,
    parentLocation = 04,
    nullLocation = 010
  };
  void message(const char *source, unsigned flags, int number);
  void message(const char *source, unsigned flags, int number,
	       const MessageArg &arg1);
  void message(const char *source, unsigned flags, int number,
	       const MessageArg &arg1, const MessageArg &arg2);
  void message(const Location &, const char *source, unsigned flags,
	       int number);
  void message(const Location &, const char *source, unsigned flags,
	       int number, const MessageArg &arg1);
  void message(const Location &, const char *source, unsigned flags,
	       int number, const MessageArg &arg1, const MessageArg &arg2);
  virtual void inputContextMessage(const char *source,
				   const Location &,
				   unsigned flags, int number,
				   const MessageArg **args,
				   int nArgs) = 0;
};

inline
void InputContext::message(const char *source,
			   unsigned flags,
			   int number)
{
  inputContextMessage(source, Location(), flags, number, 0, 0);
}

inline
void InputContext::message(const char *source,
			   unsigned flags, int number,
			   const MessageArg &arg1)
{
  const MessageArg *p = &arg1;
  inputContextMessage(source, Location(), flags, number, &p, 1);
}

inline
void InputContext::message(const Location &location,
			   const char *source,
			   unsigned flags,
			   int number)
{
  inputContextMessage(source, location, flags, number, 0, 0);
}

inline
void InputContext::message(const Location &location,
			   const char *source,
			   unsigned flags, int number,
			   const MessageArg &arg1)
{
  const MessageArg *p = &arg1;
  inputContextMessage(source, location, flags, number, &p, 1);
}

#endif /* not InputContext_INCLUDED */
