// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include <string.h>
#include "InternalInputSource.H"
#include "macros.H"

InternalInputSource::InternalInputSource(const CString &str,
					 EntityOrigin *origin)
: InputSource(origin, str.pointer(), str.pointer() + str.length()), buf_(0),
  contents_(&str)
{
}

InternalInputSource::~InternalInputSource()
{
  if (buf_)
    delete [] buf_;
}
  
Xchar InternalInputSource::fill(InputContext &)
{
  return eE;
}

void InternalInputSource::pushCharRef(Char c, const NamedCharRef &ref)
{
  ASSERT(cur() == start());
  noteCharRef(startIndex() + (cur() - start()), ref);
  if (buf_ == 0) {
    buf_ = new Char[end() - start() + 1];
    memcpy(buf_ + 1, cur(), (end() - start())*sizeof(Char));
    changeBuffer(buf_ + 1, cur());
  }
  moveLeft();
  *(Char *)cur() = c;
}

Boolean InternalInputSource::rewind(InputContext &)
{
  reset(contents_->pointer(),
	contents_->pointer() + contents_->length());
  if (buf_) {
    delete [] buf_;
    buf_ = 0;
  }
  return 1;
}
