// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef InternalInputSource_INCLUDED
#define InternalInputSource_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include <stddef.h>
#include "InputSource.H"
#include "Allocator.H"
#include "CString.H"
#include "types.H"

class EntityOrigin;
class InputContext;
class NamedCharRef;

class InternalInputSource : public InputSource {
public:
  void *operator new(size_t sz, Allocator &alloc) { return alloc.alloc(sz); }
  void *operator new(size_t sz) { return Allocator::allocSimple(sz); }
  void operator delete(void *p) { Allocator::free(p); }
  InternalInputSource(const CString &, EntityOrigin *);
  Xchar fill(InputContext &);
  void pushCharRef(Char ch, const NamedCharRef &);
  Boolean rewind(InputContext &);
  ~InternalInputSource();
private:
  InternalInputSource(const InternalInputSource &); // undefined
  void operator=(const InternalInputSource &);	    // undefined
  Char *buf_;
  const CString *contents_;
};

#endif /* not InternalInputSource_INCLUDED */
