// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef LinkProcess_INCLUDED
#define LinkProcess_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Lpd.H"
#include "IList.H"
#include "Link.H"
#include "GrowableVector.H"
#include "Vector.H"
#include "ResourcePointer.H"

class InputContext;

struct LinkProcessOpenElement : public Link {
  LinkProcessOpenElement(const LinkSet *current, const SourceLinkRule &);
  LinkProcessOpenElement(const LinkSet *current);
  const LinkSet *current;
  const LinkSet *restore;
  const LinkSet *post;
  Boolean postRestore;
};

class LinkProcess {
public:
  LinkProcess();
  void init(const ConstResourcePointer<ComplexLpd> &lpd,
	    const VectorBase<ConstResourcePointer<Lpd> > &activeLpds);
  Boolean startElement(const ElementType *,
		       const AttributeList &attributes,
		       const Location &location,
		       InputContext &ic, // for reporting errors
		       const AttributeList *&linkAttributes,
		       const ResultElementSpec *&resultElementSpec);
  void endElement();
  void uselink(const LinkSet *linkSet,
	       Boolean restore,
	       const Lpd *);
  virtual Boolean selectLinkRule(const AttributeList **linkAttributes,
				 size_t nLinkAttributes,
				 size_t &selected);
  size_t nImpliedLinkRules() const;
  const ResultElementSpec &impliedLinkRule(size_t) const;
  const CString &name() const;
  Boolean explicit() const;
  void clear();
  void moveTo(LinkProcess &);
private:
  LinkProcess(const LinkProcess &); // undefined
  void operator=(const LinkProcess &); // undefined

  IList<LinkProcessOpenElement> open_;
  ConstResourcePointer<ComplexLpd> lpd_;
  Vector<ConstResourcePointer<Lpd> > activeLpds_;
  GrowableVector<const AttributeList *> linkAttributes_;
};

inline
const CString &LinkProcess::name() const
{
  return lpd_->name();
}

inline
Boolean LinkProcess::explicit() const
{
  return lpd_->type() == Lpd::explicit;
}

#endif /* not LinkProcess_INCLUDED */
