// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "Location.H"
#include "Entity.H"

Location::Location()
{
}

Location::Location(Origin *origin, Index i)
: origin_(origin), index_(i)
{
}

Location::Location(ConstResourcePointer<Origin> origin, Index i)
: origin_(origin), index_(i)
{
}

Origin::~Origin()
{
}

const EntityOrigin *Origin::asEntityOrigin() const
{
  return 0;
}

Index Origin::refLength() const
{
  return 0;
}

BracketOrigin::BracketOrigin(const Location &loc, Position pos)
: loc_(loc), pos_(pos)
{
}

const Location &BracketOrigin::parent() const
{
  return loc_;
}

EntityOrigin::EntityOrigin(const ConstResourcePointer<Entity> &entity,
			   const Location &refLocation,
			   Index refLength)
: refLocation_(refLocation), refLength_(refLength), entity_(entity)
{
}

EntityOrigin::~EntityOrigin()
{
}

void EntityOrigin::noteCharRef(Index replacementIndex,
			       const NamedCharRef &ref)
{
  charRefs_.grow();
  charRefs_.last().replacementIndex = replacementIndex;
  charRefs_.last().ref = ref;
}

EntityOrigin::IndexType
EntityOrigin::lookupIndex(Index ind,
			  Offset &charOffset,
			  NamedCharRef &ref) const
{
#if 0
  for (size_t i = 0; i < charRefs_.length(); i++)
    if (ind <= charRefs_[i].replacementIndex)
      break;
#endif
  size_t i;
  // Find i such that
  // charRefs_[I].replacementIndex >= ind
  // charRefs_[i - 1].replacementIndex < ind
  if (charRefs_.length() == 0
      || ind > charRefs_.last().replacementIndex)
    // This will be a common case, so optimize it.
    i = charRefs_.length();
  else {
    // Binary search
    // Invariant:
    // charRefs_ < i have replacementIndex < ind
    // charRefs_ >= lim have replacementIndex >= ind
    i = 0;
    size_t lim = charRefs_.length();
    while (i < lim) {
      size_t mid = i + (lim - i)/2;
      if (charRefs_[mid].replacementIndex >= ind)
	lim = mid;
      else
	i = mid + 1;
    }
  }
  if (i < charRefs_.length() && ind == charRefs_[i].replacementIndex) {
    ref = charRefs_[i].ref;
    return replacementCharIndex;
  }
  charOffset = ind - i;
  return normalCharIndex;
}

void EntityOrigin::setExternalInfo(ExternalInfo *info)
{
  externalInfo_ = info;
}

Index EntityOrigin::refLength() const
{
  return refLength_;
}

const Location &EntityOrigin::parent() const
{
  return refLocation_;
}

const EntityOrigin *EntityOrigin::asEntityOrigin() const
{
  return this;
}

NumericCharRefOrigin::NumericCharRefOrigin(const Location &start, Index end)
: start_(start), end_(end)
{
}

const Location &NumericCharRefOrigin::parent() const
{
  return start_;
}

Index NumericCharRefOrigin::refLength() const
{
  return end_ - start_.index();
}


ReplacementOrigin::ReplacementOrigin(const Location &loc, Char origChar)
: loc_(loc), origChar_(origChar)
{
}

const Location &ReplacementOrigin::parent() const
{
  return loc_;
}

ExternalInfo::~ExternalInfo()
{
}

RTTI_DEF0(ExternalInfo)
