// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Location_INCLUDED
#define Location_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "types.H"
#include "Boolean.H"
#include "ResourcePointer.H"
#include "Resource.H"
#include "Boolean.H"
#include "Location.H"
#include "GrowableVector.H"
#include "Owner.H"
#include "NamedCharRef.H"
#include "Allocator.H"
#include "rtti.H"

class ExternalInfo;
class EntityOrigin;
class Entity;
class Location;

class Origin : public Resource {
public:
  virtual ~Origin();
  virtual const EntityOrigin *asEntityOrigin() const;
  virtual const Location &parent() const = 0;
  virtual Index refLength() const;
};

class Location {
public:
  Location();
  Location(Origin *, Index);
  Location(ConstResourcePointer<Origin>, Index);
  void operator+=(Index i) { index_ += i; }
  Index index() const { return index_; }
  const ConstResourcePointer<Origin> &origin() const { return origin_; }
private:
  ConstResourcePointer<Origin> origin_;
  Index index_;
};

class ExternalInfo {
  RTTI_CLASS
public:
  virtual ~ExternalInfo();
};

struct EntityOriginNamedCharRef {
  EntityOriginNamedCharRef() { }
  EntityOriginNamedCharRef(Index i, const NamedCharRef &r)
    : replacementIndex(i), ref(r) { }
  Index replacementIndex;
  NamedCharRef ref;
};

class EntityOrigin : public Origin {
public:
  enum IndexType {
    normalCharIndex,
    replacementCharIndex
  };
  void *operator new(size_t sz, Allocator &alloc) {
    return alloc.alloc(sz);
  }
  void *operator new(size_t sz) {
    return Allocator::allocSimple(sz);
  }
  void operator delete(void *p) {
    Allocator::free(p);
  }
  EntityOrigin(const ConstResourcePointer<Entity> &,
	       const Location &refLocation, Index refLength);
  ~EntityOrigin();
  void noteCharRef(Index replacementIndex, const NamedCharRef &);
  const ConstResourcePointer<Entity> &entity() const { return entity_; }
  IndexType lookupIndex(Index ind, Offset &charOffset,
			NamedCharRef &ref) const;
  void setExternalInfo(ExternalInfo *);
  const Location &refLocation() const;
  const EntityOrigin *asEntityOrigin() const;
  const Location &parent() const;
  const ExternalInfo *externalInfo() const;
  Index refLength() const;
private:
  EntityOrigin(const EntityOrigin &); // undefined
  void operator=(const EntityOrigin &);	// undefined
  GrowableVector<EntityOriginNamedCharRef> charRefs_;
  Owner<ExternalInfo> externalInfo_; // 0 for internal entities
  ConstResourcePointer<Entity> entity_;	// 0 for document entity
  Location refLocation_;	// where referenced from
  // total length of reference
  // (characters that were replaced by the entity)
  Index refLength_;
  // FIXME reference end type (RE or refc)
  // FIXME short references
};

class NumericCharRefOrigin : public Origin {
public:
  NumericCharRefOrigin(const Location &start, Index endIndex);
  const Location &parent() const;
  Index refLength() const;
private:
  Location start_;
  Index end_;
};

// a delimiter specified in bracketed text

class BracketOrigin : public Origin {
public:
  enum Position { open, close };
  BracketOrigin(const Location &, Position);
  const Location &parent() const;
private:
  Position pos_;
  Location loc_;
};

class ReplacementOrigin : public Origin {
public:
  ReplacementOrigin(const Location &, Char origChar);
  const Location &parent() const;
private:
  Location loc_;
  Char origChar_;
};

inline
const ExternalInfo *EntityOrigin::externalInfo() const
{
  return externalInfo_.pointer();
}

#endif /* not Location_INCLUDED */
