// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "Lpd.H"

Lpd::Lpd(const CString &name, Type type, const Location &location)
: Named(name), type_(type), location_(location), active_(0)
{
}

SimpleLpd::SimpleLpd(const CString &name, const Location &location)
: Lpd(name, simple, location)
{
}

ResultElementSpec::ResultElementSpec()
: elementType(0)
{
}

void ResultElementSpec::moveTo(ResultElementSpec &to)
{
  attributeList.moveTo(to.attributeList);
  to.elementType = elementType;
}

SourceLinkRule::SourceLinkRule()
: uselink_(0), postlink_(0), postlinkRestore_(0)
{
}

void SourceLinkRule::moveTo(SourceLinkRule &to)
{
  linkAttributes_.moveTo(to.linkAttributes_);
  resultElementSpec_.moveTo(to.resultElementSpec_);
  to.uselink_ = uselink_;
  to.postlink_ = postlink_;
  to.postlinkRestore_ = postlinkRestore_;
}

SourceLinkRuleResource::SourceLinkRuleResource()
{
}

LinkSet::LinkSet(const CString &name, const Dtd *dtd)
: Named(name), defined_(0), linkRules_(dtd ? dtd->nElementTypeIndex() : 0)
{
}

void LinkSet::addLinkRule(const ElementType *element,
			  const ConstResourcePointer<SourceLinkRuleResource> &rule)
{
  linkRules_[element->index()].grow() = rule;
}

void LinkSet::addImplied(const ElementType *element, AttributeList &attributes)
{
  ResultElementSpec &result = impliedSourceLinkRules_.grow();
  result.elementType = element;
  result.attributeList = attributes;
}

Boolean LinkSet::impliedResultAttributes(const ElementType *resultType,
					 const AttributeList *&attributes)
{
  for (size_t i = 0; i < impliedSourceLinkRules_.length(); i++)
    if (impliedSourceLinkRules_[i].elementType == resultType) {
      attributes = &impliedSourceLinkRules_[i].attributeList;
      return 1;
    }
  return 0;
}

size_t LinkSet::nLinkRules(const ElementType *e) const
{
  if (e->index() >= linkRules_.length())
    return 0;
  return linkRules_[e->index()].length();
}

IdLinkRule::IdLinkRule()
{
}

Boolean IdLinkRule::isAssociatedWith(const ElementType *e) const
{
  for (size_t i = 0; i < assocElementTypes_.length(); i++)
    if (assocElementTypes_[i] == e)
      return 1;
  return 0;
}

void IdLinkRule::setAssocElementTypes(Vector<const ElementType *> &v)
{
  v.moveTo(assocElementTypes_);
}

void IdLinkRule::moveTo(IdLinkRule &to)
{
  SourceLinkRule::moveTo(to);
  assocElementTypes_.moveTo(to.assocElementTypes_);
}

IdLinkRuleGroup::IdLinkRuleGroup(const CString &name)
: Named(name)
{
}

void IdLinkRuleGroup::addLinkRule(IdLinkRule &rule)
{
  rule.moveTo(linkRules_.grow());
}

ComplexLpd::ComplexLpd(const CString &name, Type type,
		       const Location &location,
		       const Syntax &syntax,
		       const ConstResourcePointer<Dtd> &sourceDtd,
		       const ConstResourcePointer<Dtd> &resultDtd)
: Lpd(name, type, location), sourceDtd_(sourceDtd), resultDtd_(resultDtd),
  hadIdLinkSet_(0), nAttributeDefinitionList_(0),
  initialLinkSet_(syntax.rniReservedName(Syntax::rINITIAL),
		  sourceDtd.pointer()),
  emptyLinkSet_(syntax.rniReservedName(Syntax::rEMPTY),
		sourceDtd.pointer()),
  linkAttributeDefs_(sourceDtd.isNull() ? 0 : sourceDtd->nElementTypeIndex())
{
}

IdLinkRuleGroup *ComplexLpd::lookupCreateIdLink(const CString &id)
{
  IdLinkRuleGroup *group = idLinkTable_.lookup(id);
  if (!group) {
    group = new IdLinkRuleGroup(id);
    idLinkTable_.insert(group);
  }
  return group;
}


