// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef LpdEntityRef_INCLUDED
#define LpdEntityRef_INCLUDED 1

#include "Entity.H"
#include "Boolean.H"
#include "ResourcePointer.H"

// Information about a reference to an entity that
// used a definition in an LPD.

struct LpdEntityRef {
  ConstResourcePointer<Entity> entity;
  unsigned short firstLpd;
  unsigned short limLpd;
  PackedBoolean defaulted;
  PackedBoolean found;
  void destruct() { this->LpdEntityRef::~LpdEntityRef(); }
  static inline const LpdEntityRef &key(const LpdEntityRef &r) { return r; }
  static inline unsigned long hash(const LpdEntityRef &r) {
    return Hash::hash(r.entity->name());
  }
};

inline
Boolean operator==(const LpdEntityRef &r1, const LpdEntityRef &r2)
{
  return (r1.entity == r2.entity
	  && r1.firstLpd == r2.firstLpd
	  && r1.limLpd == r2.limLpd
	  && r1.defaulted == r2.defaulted
	  && r1.found == r2.found);
}

inline
Boolean operator!=(const LpdEntityRef &r1, const LpdEntityRef &r2)
{
  return !(r1 == r2);
}

#endif /* not LpdEntityRef_INCLUDED */
