// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef MessageArg_INCLUDED
#define MessageArg_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "String.H"
#include "types.H"
#include "rtti.H"

class MessageBuilder;

class MessageArg {
public:
  MessageArg();
  virtual ~MessageArg();
  virtual MessageArg *copy() const = 0;
  virtual void append(MessageBuilder &) const = 0;
};

class StringMessageArg : public MessageArg {
public:
  StringMessageArg(const String<Char> &);
  MessageArg *copy() const;
  void append(MessageBuilder &) const;
private:
  String<Char> s_;
};

class NumberMessageArg : public MessageArg {
public:
  NumberMessageArg(unsigned long);
  MessageArg *copy() const;
  void append(MessageBuilder &) const;
private:
  unsigned long n_;
};

class OrdinalMessageArg : public MessageArg {
public:
  OrdinalMessageArg(unsigned long);
  MessageArg *copy() const;
  void append(MessageBuilder &) const;
private:
  unsigned long n_;
};

class EntityManagerMessageArg : public MessageArg {
  RTTI_CLASS
public:
  EntityManagerMessageArg();
  void append(MessageBuilder &) const;
};

#endif /* not MessageArg_INCLUDED */
