// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Named_INCLUDED
#define Named_INCLUDED 1

#include "CString.H"

class Named {
public:
  Named(const CString &name) : name_(name) { }
  virtual ~Named() { }
  const CString &name() const { return name_; }
  const CString *namePointer() const { return &name_; }
  void setName(const CString &name) { name_ = name; }
  void moveTo(Named &to) { name_.moveTo(to.name_); }
private:
  CString name_;
};

#endif /* not Named_INCLUDED */
