// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef NamedResourceTable_INCLUDED
#define NamedResourceTable_INCLUDED 1

#include "NamedResource.H"
#include "PointerTable.H"
#include "CString.H"
#include "Hash.H"
#include "ResourcePointer.H"

struct NamedResourceKeyFunction {
  static inline
    const CString &key(const NamedResource &p) {
      return p.name();
    }
};

template<class T> class NamedResourceTableIter;
template<class T> class ConstNamedResourceTableIter;

template<class T>
class NamedResourceTable {
#ifdef __lucid
  struct X {
    ResourcePointer<T> _X; // work around lcc bug
  };
#endif
public:
  NamedResourceTable() { }
  NamedResourceTable(const NamedResourceTable<T> &); // undefined
  void operator=(const NamedResourceTable<T> &);     // undefined
  ResourcePointer<T> insert(const ResourcePointer<T> &p) {
    return (T *)table_.insert((NamedResource *)p.pointer()).pointer();
  }
  ResourcePointer<T> lookup(const CString &str) const {
    return (T *)table_.lookup(str).pointer();
  }
  ConstResourcePointer<T> clookup(const CString &str) const {
    return (T *)table_.lookup(str).pointer();
  }
  size_t count() const { return table_.count(); }
private:
  PointerTable<ResourcePointer<NamedResource>, CString, Hash,
	       NamedResourceKeyFunction> table_;
  friend class NamedResourceTableIter<T>;
  friend class ConstNamedResourceTableIter<T>;
};

template<class T>
class NamedResourceTableIter {
public:
  NamedResourceTableIter(const NamedResourceTable<T> &table)
  : iter_(table.table_) { }
  ResourcePointer<T> next() {
    return (T *)iter_.next().pointer();
  }
private:
  PointerTableIter<ResourcePointer<NamedResource>, CString, Hash,
                   NamedResourceKeyFunction> iter_;
};

template<class T>
class ConstNamedResourceTableIter {
public:
  ConstNamedResourceTableIter(const NamedResourceTable<T> &table)
  : iter_(table.table_) { }
  ConstResourcePointer<T> next() {
    return (T *)iter_.next().pointer();
  }
private:
  PointerTableIter<ResourcePointer<NamedResource>, CString, Hash,
                   NamedResourceKeyFunction> iter_;
};
  
#endif /* not NamedResourceTable_INCLUDED */
