// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef NamedTable_INCLUDED
#define NamedTable_INCLUDED 1

#include "Hash.H"
#include "CString.H"
#include "Named.H"
#include "OwnerTable.H"

class NamedTableKeyFunction {
public:
  static inline const CString &key(const Named &obj) { return obj.name(); }
};

template<class T> class NamedTableIter;
template<class T> class ConstNamedTableIter;

template<class T>
class NamedTable {
public:
  NamedTable() { }
  NamedTable(const NamedTable<T> &); // undefined
  void operator=(const NamedTable<T> &); // undefined
  T *insert(T *p) { return (T *)table_.insert(p); }
  T *lookup(const CString &str) const { return (T *)table_.lookup(str); }
  size_t count() const { return table_.count(); }
  void clear() { table_.clear(); }
  void moveTo(NamedTable<T> &to) { table_.moveTo(to.table_); }
private:
  OwnerTable<Named, CString, Hash, NamedTableKeyFunction>
    table_;
  friend class NamedTableIter<T>;
  friend class ConstNamedTableIter<T>;
};

template<class T>
class NamedTableIter {
public:
  NamedTableIter(const NamedTable<T> &table) : iter_(table.table_) { }
  T *next() { return (T *)iter_.next(); }
private:
  OwnerTableIter<Named, CString, Hash, NamedTableKeyFunction> iter_;
};

template<class T>
class ConstNamedTableIter {
public:
  ConstNamedTableIter(const NamedTable<T> &table) : iter_(table.table_) { }
  const T *next() { return (T *)iter_.next(); }
private:
  OwnerTableIter<Named, CString, Hash, NamedTableKeyFunction> iter_;
};

#endif /* not NamedTable_INCLUDED */
