// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Notation_INCLUDED
#define Notation_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Owner.H"
#include "CString.H"
#include "NamedResource.H"
#include "types.H"
#include "ResourcePointer.H"
#include "ExternalId.H"
#include "Boolean.H"
#include "Attributed.H"

class Notation : public NamedResource, public Attributed {
public:
  Notation(const CString &);
  void setExternalId(ExternalId &);
  const ExternalId &externalId() const;
  Boolean defined() const;
private:
  Notation(const Notation &);	// undefined
  void operator=(const Notation &); // undefined
  PackedBoolean defined_;
  ExternalId externalId_;
  ConstResourcePointer<AttributeDefinitionList> attributeDef_;
};

inline
void Notation::setExternalId(ExternalId &id)
{
  externalId_ = id;
  defined_ = 1;
}

inline
const ExternalId &Notation::externalId() const
{
  return externalId_;
}

inline
Boolean Notation::defined() const
{
  return defined_;
}

#endif /* not Notation_INCLUDED */
