// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif

#include "Parser.H"
#include "EntityManager.H"

Parser::Parser(EntityManager *entityManager, InputSource *document,
	       const UnivCharsetDesc &initialCharset,
	       const ParserOptions &opt)
: ParserState(entityManager, opt)
{
  pushInput(document);
  Sd *sd = new Sd(initialCharset);
  sd->setBooleanFeature(Sd::fDATATAG, opt.datatag);
  sd->setBooleanFeature(Sd::fOMITTAG, opt.omittag);
  sd->setBooleanFeature(Sd::fRANK, opt.rank);
  sd->setBooleanFeature(Sd::fSHORTTAG, opt.shorttag);
  sd->setNumberFeature(Sd::fSIMPLE, opt.linkSimple);
  sd->setBooleanFeature(Sd::fIMPLICIT, opt.linkImplicit);
  sd->setNumberFeature(Sd::fEXPLICIT, opt.linkExplicit);
  sd->setNumberFeature(Sd::fCONCUR, opt.concur);
  sd->setNumberFeature(Sd::fSUBDOC, opt.subdoc);
  sd->setBooleanFeature(Sd::fFORMAL, opt.formal);
  setSd(sd);
  setDoFunction(&Parser::doInit);
}

Parser::Parser(const Parser &parent,
	       const SubdocEntity &subdoc,
	       const ResourcePointer<EntityOrigin> &origin)
: ParserState(SubdocFlag(), parent)
{
  pushInput(entityManager()->openExternal(subdoc,
					  origin.pointer(),
					  sd().docCharset(),
					  subdoc.substTable(syntax()),
					  syntax().delimGeneral(Syntax::dPERO),
					  1,
					  inputContext()));
  setDoFunction(&Parser::doProlog);
  compilePrologModes();
}

void Parser::giveUp()
{
  if (subdocLevel() > 0)
    message(Messages::subdocGiveUp);
  else
    message(Messages::giveUp);
  allDone();
}

Event *Parser::nextEvent()
{
  while (eventQueueEmpty()) {
    if (!haveDoFunction())
      return 0;
    // Use temporary to work round cfront limitation
    DoFunction f = doFunction();
    (this->*f)();
  }
  return eventQueueGet();
}

void Parser::parseAll(EventHandler &handler)
{
  while (!eventQueueEmpty())
    eventQueueGet()->handle(handler);
  // FIXME catch exceptions and reset handler.
  setHandler(&handler);
  while (haveDoFunction()) {
    // Use temporary to work round cfront limitation
    DoFunction f = doFunction();
    (this->*f)();
  }
  unsetHandler();
}
