// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Parser_INCLUDED
#define Parser_INCLUDED 1

#ifdef __GNUG__
#pragma interface
#endif

#include "types.H"
#include "Attribute.H"
#include "Attributed.H"
#include "Boolean.H"
#include "CString.H"
#include "ElementType.H"
#include "Entity.H"
#include "Event.H"
#include "IList.H"
#include "ISet.H"
#include "Location.H"
#include "Owner.H"
#include "ParserState.H"
#include "ResourcePointer.H"
#include "String.H"
#include "Undo.H"
#include "Vector.H"

class AllowedParams;
class Param;
class ExternalId;
class PublicId;
class GroupToken;
class AllowedGroupTokens;
class GroupConnector;
class AllowedGroupConnectors;
class AllowedSdParams;
class Text;
class AttributeList;
class AttributeDefinition;
class AttributeDefinitionList;
class UnivCharsetDesc;
class CharsetInfo;
class CharsetDecl;
class DeclaredValue;
class SdBuilder;
class SdParam;
class Syntax;
class ElementDefinition;
class CharSwitcher;
class StandardSyntaxSpec;
class Undo;

class Parser : private ParserState { 
public:
  // document will be deleted after use; entityManager will not.
  Parser(EntityManager *entityManager,
	 InputSource *document,
	 const UnivCharsetDesc &initialCharset,
	 const ParserOptions &options);
  Parser(const Parser &parent,
	 const SubdocEntity &subdoc,
	 const ResourcePointer<EntityOrigin> &origin);
  Event *nextEvent();
  void parseAll(EventHandler &);
  ParserState::sd;
  ParserState::syntax;
  ParserState::entityManager;
  ParserState::addInclude;
  ParserState::activateLinkType;
  ParserState::allLinkTypesActivated;
private:
  Parser(const Parser &);	// undefined
  void operator=(const Parser &); // undefined
  Boolean setStandardSyntax(Syntax &syn, const StandardSyntaxSpec &,
			    const CharsetInfo &docCharset,
			    CharSwitcher &);
  Boolean addRefDelimShortref(Syntax &syntax,
			      const CharsetInfo &docCharset,
			      CharSwitcher &switcher,
			      ISet<WideChar> &missing);
  Boolean setRefDelimGeneral(Syntax &syntax,
			     const CharsetInfo &docCharset,
			     CharSwitcher &switcher,
			     ISet<WideChar> &missing);
  void setRefNames(Syntax &syntax, const CharsetInfo &docCharset);

  void giveUp();
  void compileSdModes();
  void compilePrologModes();
  void compileInstanceModes();
  void determineNeededShortrefs(const PackedBoolean *used,
				PackedBoolean *needed);
  Boolean shortrefCanContainDelim(const CString &sr,
				  const CString &d,
				  Boolean dIsSr);
  void compileModes(const Mode *modes, int n,
		    const PackedBoolean *needShortref);
  void compileNormalMap(const PackedBoolean *needShortref);

  void doInit();
  void doProlog();
  void doDeclSubset();
  void doInstanceStart();
  void doContent();
  void extendNameToken(size_t, Messages::Type1);
  void extendNumber(size_t, Messages::Type1);
  void extendData();
  void extendS();
  void extendContentS();
  void declSubsetRecover(unsigned startLevel);
  void prologRecover();
  void skipDeclaration(unsigned startLevel);
  Boolean parseElementDecl();
  Boolean parseAttlistDecl();
  Boolean parseNotationDecl();
  Boolean parseEntityDecl();
  Boolean parseShortrefDecl();
  Boolean parseUsemapDecl();
  Boolean parseUselinkDecl();
  Boolean parseDoctypeDeclStart();
  Boolean parseDoctypeDeclEnd();
  Boolean parseMarkedSectionDeclStart();
  void handleMarkedSectionEnd();
  Boolean parseCommentDecl();
  Boolean parseExternalId(const AllowedParams &,
			  const AllowedParams &,
			  unsigned,
			  Param &,
			  ExternalId &);
  Boolean parseParam(const AllowedParams &, unsigned, Param &);
  Boolean parseMinimumLiteral(Boolean, Text &);
  Boolean parseAttributeValueLiteral(Boolean, Text &);
  Boolean parseTokenizedAttributeValueLiteral(Boolean, Text &);
  Boolean parseSystemIdentifier(Boolean, Text &);
  Boolean parseParameterLiteral(Boolean, Text &);
  Boolean parseDataTagParameterLiteral(Boolean, Text &);
  // flags for parseLiteral()
  enum {
    literalSingleSpace = 01,
    literalDataTag = 02,
    literalMinimumData = 04
    };
  Boolean parseLiteral(Mode litMode, Mode liteMode, size_t maxLength,
		       Messages::Type1 tooLongMessage, unsigned flags, Text &text);

  Boolean parseGroupToken(const AllowedGroupTokens &allow,
			  unsigned nestingLevel,
			  unsigned declInputLevel,
			  unsigned groupInputLevel,
			  GroupToken &gt);
  Boolean parseGroupConnector(const AllowedGroupConnectors &allow,
			      unsigned declInputLevel,
			      unsigned groupInputLevel,
			      GroupConnector &gc);
  Boolean parseGroup(const AllowedGroupTokens &allowToken,
		     unsigned declInputLevel,
		     Param &parm);
  Boolean parseModelGroup(unsigned nestingLevel, unsigned declInputLevel,
			  ModelGroup *&, Mode);
  Boolean parseNameGroup(unsigned declInputLevel, Param &);
  Boolean parseNameTokenGroup(unsigned declInputLevel, Param &);
  Boolean parseDataTagGroup(unsigned nestingLevel, unsigned declInputLevel,
			    GroupToken &);
  Boolean parseDataTagTemplateGroup(unsigned nestingLevel,
				    unsigned declInputLevel, GroupToken &);

  Boolean parseElementNameGroup(unsigned declInputLevel, Param &);
  Boolean parseReservedName(const AllowedParams &allow, Param &parm);
  Boolean parseIndicatedReservedName(const AllowedParams &allow, Param &parm);
  Boolean getReservedName(Syntax::ReservedName *);
  Boolean getIndicatedReservedName(Syntax::ReservedName *);
  Boolean parseAttributeValueParam(Param &parm);
  Boolean parseEntityReference(Boolean isParameter,
			       Boolean hasNameGroup,
			       ConstResourcePointer<Entity> &entity,
			       ResourcePointer<EntityOrigin> &origin);
  ContentToken::OccurrenceIndicator getOccurrenceIndicator(Mode);
  Boolean parseComment(Mode);
  Boolean parseNamedCharRef();
  Boolean parseNumericCharRef(Char &, Location &);
  Boolean parseDeclarationName(Syntax::ReservedName *);
  void paramInvalidToken(Token, const AllowedParams &);
  void groupTokenInvalidToken(Token, const AllowedGroupTokens &);
  void groupConnectorInvalidToken(Token, const AllowedGroupConnectors &);
  ElementType *lookupCreateElement(const CString &);
  RankStem *lookupCreateRankStem(const CString &);
  Boolean parseExceptions(unsigned declInputLevel,
			  ResourcePointer<ElementDefinition> &def);
  void parsePcdata();
  void parseStartTag();
  const ElementType *completeRankStem(const CString &);
  void handleRankedElement(const ElementType *);
  Boolean parseStartTagClose(AttributeList &, Token &);
  void parseEmptyStartTag();
  void acceptPcdata(const Location &);
  void acceptStartTag(const ElementType *, StartElementEvent *);
  void undo(IList<Undo> &);
  Boolean tryStartTag(const ElementType *, StartElementEvent *,
		      IList<ElementEvent> &);
  void checkExclusion(const ElementType *e);
  Boolean tryImplyTag(const Location &, unsigned &, unsigned &,
		      IList<Undo> &, IList<ElementEvent> &);
  void pushElementCheck(const ElementType *, StartElementEvent *);
  void pushElementCheck(const ElementType *, StartElementEvent *,
			IList<Undo> &, IList<ElementEvent> &);
  void queueElementEvents(IList<ElementEvent> &);
  Boolean parseAttributeSpec(Boolean inDeclaration,
			     AttributeList &,
			     Token &closeToken);
  void handleAttributeNameToken(CString &token,
				Text &text,
				AttributeList &,
				unsigned &specLength);
  struct AttributeParameter {
    AttributeParameter() { }
    enum Type {
      end,
      name,
      nameToken,
      vi
      };
    Type type;
    CString token;
    Token closeToken;
    Text text;
  };

  Boolean parseAttributeParameter(Boolean inDecl,
				  Boolean allowVi,
				  AttributeParameter &result);

  Boolean parseAttributeValueSpec(Boolean inDecl,
				  const CString &name,
				  const CString &origName,
				  AttributeList &atts,
				  unsigned &specLength);

  void parseEndTag();
  void parseEndTagClose(EndElementEvent::Minimization &);
  void parseEmptyEndTag();
  void parseNullEndTag();
  void endAllElements();
  void acceptEndTag(const ElementType *, EndElementEvent *);
  void implyCurrentElementEnd(const Location &);
  void maybeDefineEntity(const ResourcePointer<Entity> &entity);
  Notation *lookupCreateNotation(const CString &name);
  Boolean parseExternalEntity(const Location &loc,
			      CString &name,
			      Entity::DeclType declType,
			      unsigned declInputLevel,
			      Param &parm);
  ShortReferenceMap *lookupCreateMap(const CString &);
  void handleShortref(int index);
  Boolean parseProcessingInstruction();
  Boolean parseAttributed(unsigned declInputLevel, Param &parm,
			  Vector<Attributed *> &attributed,
			  Boolean &isNotation);
  Boolean parseDeclaredValue(unsigned declInputLevel, Boolean isNotation,
			     Param &parm, Owner<DeclaredValue> &value);
  Boolean parseDefaultValue(unsigned declInputLevel, Boolean isNotation,
			    Param &parm, const CString &attributeName,
			    Owner<DeclaredValue> &declaredValue,
			    Owner<AttributeDefinition> &def);
  Boolean reportNonSgmlCharacter();
  void endInstance();
  Boolean implySgmlDecl();
  Boolean scanForSgmlDecl(const CharsetInfo &initCharset);
  void findMissingMinimum(const CharsetInfo &charset, ISet<WideChar> &);
  Boolean parseSgmlDecl();
  Boolean sdParseDocumentCharset(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseCapacity(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseScope(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseSyntax(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseSyntaxCharset(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseShunchar(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseFunction(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseNaming(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseDelim(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseNames(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseQuantity(SdBuilder &sdBuilder, SdParam &parm);
  Boolean sdParseFeatures(SdBuilder &sd, SdParam &parm);
  Boolean sdParseAppinfo(SdBuilder &sd, SdParam &parm);
  Boolean parseSdParam(const AllowedSdParams &allow, SdParam &);
  Boolean parseSdParamLiteral(Boolean lita, String<SyntaxChar> &str);
  Boolean stringToNumber(const Char *s, size_t length, unsigned long &);
  void sdParamInvalidToken(Token token, const AllowedSdParams &);
  Boolean sdParseCharset(SdBuilder &sdBuilder, SdParam &parm,
			 Boolean isDocument,
			 CharsetDecl &, UnivCharsetDesc &);
  Boolean translateSyntax(SdBuilder &sdBuilder,
			  WideChar syntaxChar, Char &docChar);
  Boolean translateSyntax(SdBuilder &sdBuilder,
			  const String<SyntaxChar> &syntaxString,
			  CString &docString);
  Boolean translateName(SdBuilder &sdBuilder,
			const CString &name,
			CString &str);
  Boolean univToDescCheck(const CharsetInfo &charset, UnivChar from,
			  Char &to);
  Boolean checkNotFunction(const Syntax &syn, Char c);
  Boolean checkGeneralDelim(const Syntax &syn, const CString &delim);
  Boolean checkShortrefDelim(const Syntax &syn,
			     const CharsetInfo &charset,
			     const CString &delim);
  Boolean checkNmchar(const Syntax &syn, UnivChar univChar, Char docChar);
  Boolean checkSwitch(UnivChar univChar);
  const StandardSyntaxSpec *lookupSyntax(const PublicId &id);
  void checkIdrefs();
  void checkTaglen(Index tagStartIndex);
  void checkSyntaxNamelen(const Syntax &syn);
  void checkElementAttribute(const ElementType *e);
  void checkDtd(Dtd &dtd);
  void doEndDtd();
  void reportAmbiguity(const LeafContentToken *from,
		       const LeafContentToken *to1,
		       const LeafContentToken *to2,
		       unsigned ambigAndDepth);
  Boolean parseLinktypeDeclStart();
  Boolean parseLinktypeDeclEnd();
  Boolean parseLinkDecl();
  Boolean parseIdlinkDecl();
  void doEndLpd();
  Boolean parseLinkSet(Boolean idlink);
  Boolean parseLinkAttlistDecl();
  void addIdLinkRule(const CString &id, IdLinkRule &rule);
  void addLinkRule(LinkSet *linkSet,
		   const ElementType *sourceElement,
		   const ConstResourcePointer<SourceLinkRuleResource> &linkRule);
  Boolean parseResultElementSpec(unsigned declInputLevel,
				 Param &parm,
				 Boolean idlink,
				 Boolean &implied,
				 const ElementType *&resultType,
				 AttributeList &attributes);
  LinkSet *lookupCreateLinkSet(const CString &name);
  const ElementType *lookupSourceElementType(const CString &name);
  const ElementType *lookupResultElementType(const CString &name);
  void endProlog();
  void outputLinks();
  Boolean parseEntityReferenceNameGroup(Boolean &active);
  Boolean parseTagNameGroup(Boolean &active);
  void parseGroupStartTag();
  void parseGroupEndTag();
  Boolean skipAttributeSpec(Token &closeToken);
};


#endif /* not Parser_INCLUDED */
