// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Priority_INCLUDED
#define Priority_INCLUDED 1

#include <limits.h>
#include "Boolean.H"

class Priority {
public:
  typedef unsigned char Type;
  enum {
    data = 0,
    function = 1,
    delim = UCHAR_MAX
    };
  static inline Type blank(int n) {
    // `Priority::' works round gcc 2.5.5 bug
    return Priority::Type(n + 1);
  }
  static inline Boolean isBlank(Type t) {
    return function < t && t < delim;
  }
};

#endif /* not Priority_INCLUDED */
