// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "RangeMap.H"
#include "ISet.H"
#include "types.H"

template<class From, class To>
RangeMap<From, To>::RangeMap()
{
}

template<class From, class To>
Boolean RangeMap<From, To>::map(From from, To &to) const
{
  // FIXME use binary search
  for (size_t i = 0; i < ranges_.length(); i++) {
    const RangeMapRange<From,To> &r(ranges_[i]);
    if (r.fromMin <= from && from <= r.fromMax) {
      to = r.toMin + (from - r.fromMin);
      return 1;
    }
  }
  return 0;
}

typedef ISet<WideChar> RangeMap_dummy;

// Return 0 for no matches, 1 for 1, 2 for more than 1.

template<class From, class To>
unsigned RangeMap<From, To>::inverseMap(To to, From &from,
					ISet<WideChar> &fromSet) const
{
  // FIXME use binary search
  unsigned ret = 0;
  for (size_t i = 0; i < ranges_.length(); i++) {
    const RangeMapRange<From,To> &r(ranges_[i]);
    if (r.toMin <= to && to <= r.toMin + (r.fromMax - r.fromMin)) {
      From n = r.fromMin + (to - r.toMin);
      if (ret > 1)
	fromSet.add(n);
      else if (ret == 1) {
	fromSet.add(from);
	fromSet.add(n);
	ret = 1;
      }
      else {
	from = n;
	ret = 1;
      }
    }
  }
  return ret;
}

template<class From, class To>
RangeMapIter<From, To>::RangeMapIter(const RangeMap<From, To> &map)
: count_(map.ranges_.length()), ptr_(map.ranges_.pointer())
{
}

// If the new range overlaps an existing one, the new
// one takes precedence.

template<class From, class To>
void RangeMap<From, To>::addRange(From fromMin, From fromMax, To toMin)
{
  // FIXME use binary search
  for (size_t i = ranges_.length(); i > 0; i--)
    if (fromMin > ranges_[i - 1].fromMax)
      break;
  // fromMin <= ranges[i].fromMax
  Boolean coalesced = 0;
  if (i > 0
      && ranges_[i - 1].fromMax + 1 == ranges_[i - 1].fromMin
      && ranges_[i - 1].toMin + (fromMin - ranges_[i - 1].fromMin) == toMin) {
    // coalesce with previous
    ranges_[i - 1].fromMax = fromMax;
    i--;
    coalesced = 1;
  }
  else if (i < ranges_.length() && fromMax >= ranges_[i].fromMin - 1) {
    // overlap
    if (fromMin <= ranges_[i].fromMin) {
      if (toMin + (ranges_[i].fromMin - fromMin) == ranges_[i].toMin) {
	ranges_[i].fromMin = fromMin;
	if (fromMax <= ranges_[i].fromMax)
	  return;
	ranges_[i].fromMax = fromMax;
	coalesced = 1;
      }
    }
    else {
      // fromMin > ranges_[i].fromMin
      if (ranges_[i].toMin = toMin + (fromMin - ranges_[i].fromMin)) {
	if (fromMax < ranges_[i].fromMax)
	  return;
	ranges_[i].fromMax = fromMax;
	coalesced = 1;
      }
    }
  }
  if (!coalesced) {
    // insert
    ranges_.grow();
    for (size_t j = ranges_.length() - 1; j > i; j--)
      ranges_[j] = ranges_[j - 1];
    ranges_[i].fromMin = fromMin;
    ranges_[i].fromMax = fromMax;
    ranges_[i].toMin = toMin;
  }
  // Delete overlapping ranges starting at i + 1.
  for (size_t j = i + 1; j < ranges_.length(); j++) {
    if (fromMax < ranges_[j].fromMax) {
      if (fromMax >= ranges_[j].fromMin)
	ranges_[j].fromMin = fromMax + 1;
      break;
    }
  }
  if (j > i + 1) {
    // delete i + 1 ... j - 1
    // j -> i + 1
    // j - 1 -> i + 2
    size_t count = ranges_.length() - j;
    for (size_t k = 0; k < count; k++)
      ranges_[i + 1 + count] = ranges_[j + count];
    ranges_.setLength(ranges_.length() - (j - (i + 1)));
  }
}
