// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef RangeMap_INCLUDED
#define RangeMap_INCLUDED 1

#include "GrowableVector.H"
#include "Boolean.H"
#include "types.H"
#include <stddef.h>

template<class From, class To>
struct RangeMapRange {
  From fromMin;
  From fromMax;
  To toMin;
};

template<class From, class To> class RangeMapIter;
#ifdef __GNUG__
#include "ISet.H"
#else
template<class T> class ISet;
#endif

template<class From, class To>
class RangeMap {
public:
  RangeMap();
  Boolean map(From, To &) const;
  // Return 0 for no matches, 1 for 1, 2 for more than 1.
  unsigned inverseMap(To, From &, ISet<WideChar> &) const;
  void addRange(From, From, To);
private:
  GrowableVector<RangeMapRange<From,To> > ranges_;
  friend class RangeMapIter<From,To>;
};

template<class From, class To>
class RangeMapIter {
public:
  RangeMapIter(const RangeMap<From,To> &map);
  Boolean next(From &fromMin, From &fromMax, To &toMin) {
    if (!count_)
      return 0;
    else {
      fromMin = ptr_->fromMin;
      fromMax = ptr_->fromMax;
      toMin = ptr_->toMin;
      ptr_++;
      count_--;
      return 1;
    }
  }
private:
  size_t count_;
  const RangeMapRange<From,To> *ptr_;
};

#ifdef DEFINE_TEMPLATES
#include "RangeMap.C"
#endif

#endif /* not RangeMap_INCLUDED */
