// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "Resource.H"
#include "Trie.H"
#include "Owner.H"
#include "XcharMap.H"
#include "Recognizer.H"
#include "InputContext.H"
#include "InputSource.H"

Recognizer::Recognizer(Trie *trie, const XcharMap<EquivCode> &map)
: trie_(trie), map_(map), multicode_(0)
{
}

Recognizer::Recognizer(Trie *trie, const XcharMap<EquivCode> &map,
		       Vector<Token> &suppressTokens)
: trie_(trie), map_(map), multicode_(1)
{
  suppressTokens.moveTo(suppressTokens_);
}

Token Recognizer::recognize(InputSource *in, InputContext &ic) const
{
  if (multicode_) {
    in->startToken();
    if (in->scanSuppress())
      return suppressTokens_[map_[in->tokenChar(ic)]];
  }
  else
    in->startTokenNoMulticode();
  register const Trie *pos = trie_.pointer();
  do {
    pos = pos->next(map_[in->tokenChar(ic)]);
  } while (pos->hasNext());
  if (!pos->blank()) {
    in->endToken(pos->tokenLength());
    return pos->token();
  }
  const BlankTrie *b = pos->blank();
  const Trie *newPos = b;
  size_t maxBlanks = b->maxBlanksToScan();
  for (size_t nBlanks = 0; nBlanks < maxBlanks; nBlanks++) {
    EquivCode code = map_[in->tokenChar(ic)];
    if (!b->codeIsBlank(code)) {
      if (newPos->hasNext())
	newPos = newPos->next(code);
      break;
    }
  }
  while (newPos->hasNext())
    newPos = newPos->next(map_[in->tokenChar(ic)]);
  if (newPos->token() != 0) {
    in->endToken(newPos->tokenLength() + b->additionalLength() + nBlanks);
    return newPos->token();
  }
  else {
    in->endToken(pos->tokenLength() + (pos->includeBlanks() ? nBlanks : 0));
    return pos->token();
  }
}

