// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef Recognizer_INCLUDED
#define Recognizer_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "Resource.H"
#include "Owner.H"
#include "XcharMap.H"
#include "types.H"
#include "Vector.H"

class InputContext;
class InputSource;
class Trie;

class Recognizer : public Resource {
public:
  Recognizer(Trie *, const XcharMap<EquivCode> &);
  Recognizer(Trie *, const XcharMap<EquivCode> &, Vector<Token> &);
  Token recognize(InputSource *, InputContext &) const;
private:
  Recognizer(const Recognizer &); // undefined
  void operator=(const Recognizer &); // undefined
  Boolean multicode_;
  Owner<Trie> trie_;
  XcharMap<EquivCode> map_;
  Vector<Token> suppressTokens_;
};

#endif /* not Recognizer_INCLUDED */
