// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#include "SgmlParser.H"
#include "Parser.H"

const char SgmlParser::messageSource[] = "SgmlParser";

SgmlParser::SgmlParser(EntityManager *entityManager,
		       InputSource *document,
		       const UnivCharsetDesc &docCharset,
		       const ParserOptions &options)
: parser_(new Parser(entityManager, document, docCharset, options))
{
}

SgmlParser::SgmlParser(const SgmlParser &parent,
		       const SubdocEntity &subdoc,
		       const ResourcePointer<EntityOrigin> &origin)
: parser_(new Parser(*parent.parser_, subdoc, origin))
{
}

SgmlParser::~SgmlParser()
{
  delete parser_;
}

Event *SgmlParser::nextEvent()
{
  return parser_->nextEvent();
}

void SgmlParser::parseAll(EventHandler &handler)
{
  parser_->parseAll(handler);
}

const Sd &SgmlParser::sd() const
{
  return parser_->sd();
}

const Syntax &SgmlParser::syntax() const
{
  return parser_->syntax();
}

EntityManager &SgmlParser::entityManager() const
{
  return *parser_->entityManager();
}

void SgmlParser::addInclude(const CString &str)
{
  parser_->addInclude(str);
}

void SgmlParser::activateLinkType(const CString &name)
{
  parser_->activateLinkType(name);
}

void SgmlParser::allLinkTypesActivated()
{
  parser_->allLinkTypesActivated();
}

