// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef SgmlParser_INCLUDED
#define SgmlParser_INCLUDED 1

#include "CString.H"

class Event;
class Parser;
class EntityManager;
class InputSource;
class UnivCharsetDesc;
class EventHandler;
class ParserOptions;
class SubdocEntity;
template<class T> class ResourcePointer;
class EntityOrigin;
class Sd;
class Syntax;

class SgmlParser {
public:
  // document will be deleted after use; entityManager will not.
  SgmlParser(EntityManager *entityManager,
	     InputSource *document,
	     const UnivCharsetDesc &docCharset,
	     const ParserOptions &options);
  // for parsing subdocuments
  SgmlParser(const SgmlParser &parent,
	     const SubdocEntity &subdoc,
	     const ResourcePointer<EntityOrigin> &origin);
  ~SgmlParser();
  SgmlParser(const SgmlParser &); // not defined
  SgmlParser &operator=(const SgmlParser &); // not defined
  Event *nextEvent();
  void parseAll(EventHandler &);
  const Sd &sd() const;
  const Syntax &syntax() const;
  EntityManager &entityManager() const;
  void addInclude(const CString &);
  void activateLinkType(const CString &);
  void allLinkTypesActivated();
  static const char *messageText(int);
  static const char *fragmentText(int);
  static const char messageSource[];
private:
  Parser *parser_;
};

#endif /* not SgmlParser_INCLUDED */
