// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef ShortReferenceMap_INCLUDED
#define ShortReferenceMap_INCLUDED 1

#include "Vector.H"
#include "CString.H"
#include "Named.H"
#include "Boolean.H"
#include "Entity.H"
#include "ResourcePointer.H"

class ShortReferenceMap : public Named {
public:
  ShortReferenceMap(const CString &);
  ShortReferenceMap(const ShortReferenceMap &);	// undefined
  void operator=(const ShortReferenceMap &);	// undefined
  Boolean defined() const;
  void setNameMap(Vector<CString> &map);
  void setEntityMap(Vector<ConstResourcePointer<Entity> > &map);
  Boolean lookup(int i, const CString *&) const;
  const CString *entityName(int i) const;
  const ConstResourcePointer<Entity> &entity(int i) const;
private:
  Vector<CString> nameMap_;
  Vector<ConstResourcePointer<Entity> > entityMap_;
  ConstResourcePointer<Entity> nullEntity_;
};

inline
ShortReferenceMap::ShortReferenceMap(const CString &name)
: Named(name)
{
}

inline
Boolean ShortReferenceMap::defined() const
{
  return nameMap_.length() > 0;
}


inline
const CString *ShortReferenceMap::entityName(int i) const
{
  if (i < nameMap_.length() && nameMap_[i].length() != 0)
    return &nameMap_[i];
  else
    return 0;
}

inline
const ConstResourcePointer<Entity> &ShortReferenceMap::entity(int i) const
{
  if (i < entityMap_.length())
    return entityMap_[i];
  else
    return nullEntity_;
}

inline
void ShortReferenceMap::setNameMap(Vector<CString> &map)
{
  map.moveTo(nameMap_);
}

inline
void ShortReferenceMap::setEntityMap(Vector<ConstResourcePointer<Entity> >
				     &map)
{
  map.moveTo(entityMap_);
}

#endif /* not ShortReferenceMap_INCLUDED */
