// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "Text.H"
// for memcmp()
#include <string.h>

Text::Text()
{
}

void Text::addChar(Char c, const Location &loc)
{
  if (items_.length() == 0
      || items_.last().type != TextItem::data
      || loc.origin().pointer() != items_.last().loc.origin().pointer()
      || loc.index() != (items_.last().loc.index()
			 + (chars_.length() - items_.last().index))) {
    items_.grow();
    items_.last().loc = loc;
    items_.last().type = TextItem::data;
    items_.last().index = chars_.length();
  }
  chars_ += c;
}

void Text::addChars(const Char *p, size_t length, const Location &loc)
{
  items_.grow();
  items_.last().loc = loc;
  items_.last().type = TextItem::data;
  items_.last().index = chars_.length();
  chars_.append(p, length);
}

void Text::addSimple(TextItem::Type type, const Location &loc)
{
  items_.grow();
  items_.last().loc = loc;
  items_.last().type = type;
  items_.last().index = chars_.length();
}

void Text::ignoreChar(Char c, const Location &loc)
{
  items_.grow();
  items_.last().loc = loc;
  items_.last().type = TextItem::ignore;
  items_.last().c = c;
  items_.last().index = chars_.length();
}

void Text::ignoreLastChar()
{
  size_t lastIndex = chars_.length() - 1;
  for (size_t i = items_.length() - 1; items_[i].index > lastIndex; i--)
    ;
  // lastIndex >= items_[i].index
  if (items_[i].index != lastIndex) {
    items_.grow();
    i++;
    for (size_t j = items_.length() - 1; j > i; j--)
      items_[j] = items_[j - 1];
    items_[i].index = lastIndex;
    items_[i].loc = items_[i - 1].loc;
    items_[i].loc += lastIndex - items_[i - 1].index;
  }
  
  items_[i].c = chars_[chars_.length() - 1];
  items_[i].type = TextItem::ignore;
  for (size_t j = i + 1; j < items_.length(); j++)
    items_[j].index = lastIndex;
  chars_.setLength(chars_.length() - 1);
}

void Text::clear()
{
  chars_.clear();
  items_.clear();
}

void Text::destruct()
{
  this->Text::~Text();
}

TextItem::TextItem()
{
}

void TextItem::destruct()
{
  this->TextItem::~TextItem();
}

void Text::moveTo(Text &to)
{
  items_.moveTo(to.items_);
  chars_.moveTo(to.chars_);
}

EsisTextIter::EsisTextIter(const Text &text)
: ptr_(&text),
  charIndex_(0),
  itemIndex_(0)
{
}

Boolean EsisTextIter::next(Type &type, const Char *&ptr, size_t &length)
{
  const GrowableVectorD<TextItem> &items(ptr_->items_);
  const CString &chars(ptr_->chars_);
  while (itemIndex_ < items.length()
	 && (items[itemIndex_].index < charIndex_
	     || items[itemIndex_].type != TextItem::sdataEntityStart))
    itemIndex_++;
  if (itemIndex_ >= items.length()) {
    if (charIndex_ >= chars.length())
      return 0;
    ptr = &chars[charIndex_];
    length = chars.length() - charIndex_;
    type = data;
    charIndex_ = chars.length();
  }
  else {
    size_t sdataStartIndex = items[itemIndex_].index;
    if (sdataStartIndex == charIndex_) {
      while (items[++itemIndex_].type != TextItem::sdataEntityEnd)
	;
      size_t sdataEndIndex = items[itemIndex_++].index;
      ptr = &chars[charIndex_];
      type = sdata;
      length = sdataEndIndex - sdataStartIndex;
      charIndex_ = sdataEndIndex;
    }
    else {
      // sdataStartIndex > charIndex
      ptr = &chars[charIndex_];
      length = sdataStartIndex - charIndex_;
      type = data;
      charIndex_ = sdataStartIndex;
    }
  }
  return 1;
}

void Text::insertChars(const CString &s, const Location &loc)
{
  chars_.insert(0, s);
  items_.grow();
  for (size_t i = items_.length() - 1; i > 0; i--) {
    items_[i] = items_[i - 1];
    items_[i].index += s.length();
  }
  items_[0].loc = loc;
  items_[0].type = TextItem::data;
  items_[0].index = 0;
}

size_t Text::nDataEntities() const
{
  size_t n = 0;
  for (size_t i = 0; i < items_.length(); i++)
    if (items_[i].type == TextItem::cdataEntityStart
	|| items_[i].type == TextItem::sdataEntityStart)
      n++;
  return n;
}

// This is used to determine for a FIXED CDATA attribute
// whether a specified value if equal to the default value.

Boolean Text::fixedEqual(const Text &text) const
{
  EsisTextIter i1(*this);
  EsisTextIter i2(text);
  for (;;) {
    EsisTextIter::Type type1, type2;
    const Char *p1, *p2;
    size_t n1, n2;
    if (!i1.next(type1, p1, n1))
      return !i2.next(type2, p2, n2);
    if (!i2.next(type2, p2, n2)
	|| type1 != type2
	|| n1 != n2
	|| memcmp(p1, p2, n1*sizeof(Char)) != 0)
      return 0;
  }
  return 1;
}

Location Text::charLocation(size_t ind) const
{
  // Find the last item whose index <= ind.
  // Invariant:
  // indexes < i implies index <= ind
  // indexes >= lim implies index > ind
  // The first item will always have index 0.
  size_t i = 1;
  size_t lim = items_.length();
  while (i < lim) {
    size_t mid = i + (lim - i)/2;
    if (items_[mid].index > ind)
      lim = mid;
    else
      i = mid + 1;
  }
#if 0
  for (size_t i = 1; i < items_.length(); i++)
    if (items_[i].index > ind)
      break;
#endif
  i--;
  Location loc(items_[i].loc);
  loc += ind - items_[i].index;
  return loc;
}
