// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifdef __GNUG__
#pragma implementation
#endif
#include "TokenMessageArg.H"
#include "MessageBuilder.H"
#include "token.H"
#include "Fragments.H"
#include "Mode.H"
#include "ModeInfo.H"
#include "macros.H"

TokenMessageArg::TokenMessageArg(Token token, Mode mode,
				 const ConstResourcePointer<Syntax> &syntax,
				 const ConstResourcePointer<Sd> &sd)
: token_(token), mode_(mode), syntax_(syntax), sd_(sd)
{
}

MessageArg *TokenMessageArg::copy() const
{
  return new TokenMessageArg(*this);
}

void TokenMessageArg::append(MessageBuilder &builder) const
{
  // FIXME translate function characters in delimiters into
  // &#NAME; form.
  if (token_ >= tokenFirstShortref) {
    const CString &delim(syntax_->delimShortref(token_ - tokenFirstShortref));
    builder.appendFragment(Fragments::delimStart);
    builder.appendChars(delim.pointer(), delim.length());
    builder.appendFragment(Fragments::delimEnd);
    return;
  }
  if (token_ == tokenEe) {
    builder.appendFragment(Fragments::entityEnd);
    return;
  }
  ModeInfo iter(mode_, *sd_);
  TokenInfo info;
  int fragment = Fragments::invalidFragment;
  while (iter.nextToken(&info))
    if (info.token == token_) {
      switch (info.type) {
      case TokenInfo::delimType:
      case TokenInfo::delimDelimType:
      case TokenInfo::delimSetType:
	{
	  const CString &delim(syntax_->delimGeneral(info.delim1));
	  builder.appendFragment(Fragments::delimStart);
	  builder.appendChars(delim.pointer(), delim.length());
	  fragment = Fragments::delimEnd;
	}
	break;
      case TokenInfo::setType:
	switch (info.set) {
	case Syntax::digit:
	  fragment = Fragments::digit;
	  break;
	case Syntax::nameStart:
	  fragment = Fragments::nameStartCharacter;
	  break;
	case Syntax::sepchar:
	  fragment = Fragments::sepchar;
	  break;
	case Syntax::s:
	  fragment = Fragments::separator;
	  break;
	case Syntax::nmchar:
	  fragment = Fragments::nameCharacter;
	  break;
	case Syntax::sgmlChar:
	  fragment = Fragments::dataCharacter;
	  break;
	case Syntax::minimumData:
	  fragment = Fragments::minimumDataCharacter;
	  break;
	case Syntax::significant:
	  fragment = Fragments::significantCharacter;
	  break;
	default:
	  CANNOT_HAPPEN();
	}
	break;
      case TokenInfo::functionType:
	switch (info.function) {
	case Syntax::fRE:
	  fragment = Fragments::recordEnd;
	  break;
	case Syntax::fRS:
	  fragment = Fragments::recordStart;
	  break;
	case Syntax::fSPACE:
	  fragment = Fragments::space;
	  break;
	}
	break;
      }
      break;
    }
  builder.appendFragment(fragment);
}
