// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef TokenMessageArg_INCLUDED
#define TokenMessageArg_INCLUDED 1
#ifdef __GNUG__
#pragma interface
#endif

#include "MessageArg.H"
#include "types.H"
#include "Mode.H"
#include "Syntax.H"
#include "Sd.H"
#include "ResourcePointer.H"

class TokenMessageArg : public MessageArg {
public:
  TokenMessageArg(Token token, Mode mode,
		  const ConstResourcePointer<Syntax> &syntax,
		  const ConstResourcePointer<Sd> &sd);
  MessageArg *copy() const;
  void append(MessageBuilder &) const;
private:
  Token token_;
  Mode mode_;
  ConstResourcePointer<Syntax> syntax_;
  ConstResourcePointer<Sd> sd_;
};

#endif /* not TokenMessageArg_INCLUDED */
