// Copyright (c) 1994 James Clark
// See the file COPYING for copying permission.

#ifndef XcharMap_INCLUDED
#define XcharMap_INCLUDED 1

#include "types.H"
#include "Resource.H"
#include "ResourcePointer.H"

template<class T>
class SharedXcharMap : public Resource {
public:
  SharedXcharMap();
  SharedXcharMap(T defaultValue);
  T *ptr() { return v + 1; }
private:
  T v[2 + Char(-1)];
};

template<class T>
class XcharMap {
public:
  XcharMap();
  XcharMap(T defaultValue);
  T operator[](Xchar c) const { return ptr_[c]; }
  void setRange(Char min, Char max, T val);
  void setChar(Char c, T val) { ptr_[c] = val; }
  void setEe(T val) { ptr_[-1] = val; }
  void clear() { ptr_ = 0; sharedMap_.clear(); }
private:
  T *ptr_;
  ResourcePointer<SharedXcharMap<T> > sharedMap_;
};

#ifdef DEFINE_TEMPLATES
#include "XcharMap.C"
#endif

#endif /* not XcharMap_INCLUDED */
