#! /usr/bin/perl
# Copyright (c) 1994 James Clark
# See the file COPYING for copying permission.

open(DEF, "messages.def") || die "can't open \`messages.def': $!\n";

while (<DEF>) {
    chop;
    next if /^[ 	]*#/;
    next if /^[ 	]*$/;
    @field = split(':', $_, 4);
    &error("too few fields") if $#field != 3;
    $num = int(substr($field[0], 0, 3));
    $field[0] =~ /^[0-9][0-9][0-9][IWQE][0-9]$/ || &error("invalid first field");;
    &error("duplicate message number $num") if defined($type[$num]);
    $type[$num] = substr($field[0], 3, 1);
    $nargs[$num] = int(substr($field[0], 4, 1));
    $field[1] =~ /^[a-zA-Z_][a-zA-Z0-9_]+$/ || &error("invalid tag");
    $tag[$num] = $field[1];
    &error("duplicate tag $field[1]") if defined($tag_used{$field[1]});
    $tag_used{$field[1]} = 1;
    $field[2] =~ /^([0-9]+(\.[0-9]+)*(p[0-9]+)?( [0-9]+(\.[0-9]+)*(p[0-9]+)?)*)?$/
	|| &error("invalid clauses field");
    # $clauses[$num] = $field[2];
    if ($nargs[$num] == 0) {
	$field[3] =~ /^([^%]|%[%L])*$/ || &error("invalid character after %");
    }
    else {
	$field[3] =~ /^([^%]|%[%L1-$nargs[$num]])*$/ || &error("invalid character after %");
    }
    $auxloc[$num] = 1 if ($field[3] =~ /^([^%]|%[%1-9])*%L/);
    $field[3] =~ s|\\|\\\\|g;
    $field[3] =~ s|"|\\"|g;
    $message[$num] = $field[3];
}

close(DEF);

unlink("Messages.H");
open(HEADER, ">Messages.H");
chmod 0444, "Messages.H";
select(HEADER);
print <<END;
// This file was automatically generated from messages.def by msggen.pl.
#ifndef Messages_INCLUDED
#define Messages_INCLUDED 1

struct Messages {
END

for ($n = 0; $n < 10; $n++) {
    $first = 1;
    print "  enum Type$n {";
    for ($i = 0; $i <= $#nargs; $i++) {
	if (defined($nargs[$i]) && $nargs[$i] == $n && !$auxloc[$i]) {
	    if ($first) {
		$first = 0;
	    }
	    else {
		print ",";
	    }
	    print "\n    $tag[$i] = $i";
	}
    }
    print "\n  };\n";
    $first = 1;
    print "  enum Type${n}L {";
    for ($i = 0; $i <= $#nargs; $i++) {
	if (defined($nargs[$i]) && $nargs[$i] == $n && $auxloc[$i]) {
	    if ($first) {
		$first = 0;
	    }
	    else {
		print ",";
	    }
	    print "\n    $tag[$i] = $i";
	}
    }
    print "\n  };\n";
}

print <<END;
};

#endif /* not Messages_INCLUDED */
END

close(HEADER);
unlink("messageType.H");
open(TYPE, ">messageType.H");
chmod 0444, "messageType.H";
select(TYPE);

print <<END;
// This file was automatically generated from messages.def by msggen.pl.

MessageEvent::Type ParserState::messageType[] = {
END

foreach $t (@type) {
    print "  ";
    if (defined($t)) {
	if ($t eq "I") {
	    $s = "info";
	}
	elsif ($t eq "W") {
	    $s = "warning";
	}
	elsif ($t eq "E") {
	    $s = "error";
	}
	elsif ($t eq "Q") {
	    $s = "quantityError";
	}
	else {
	    die "can't happen";
	}
	printf "MessageEvent::%s,\n", $s;
    }
    else {
	print "MessageEvent::Type(0),\n";
    }
}

print "};\n";
close(TYPE);

unlink("messageText.C");
open(TEXT, ">messageText.C");
chmod 0444, "messageText.C";
select(TEXT);
print <<END;
// This file was automatically generated from messages.def by msggen.pl.
#include "SgmlParser.H"

static const char *const text[] = {
END

foreach $s (@message) {
    print "  ";
    if (defined($s)) {
	printf "\"%s\",\n", $s;
    }
    else {
	print "0,\n";
    }
}

print <<END;
};

const char *SgmlParser::messageText(int n)
{
  return n < 0 || n >= sizeof(text)/sizeof(text[0]) ? 0 : text[n];
}
END

close(TEXT);

sub error {
    die "messages.def:$.: $_[0]\n";
}
