'From Squeak3.6 of ''6 October 2003'' [latest update: #5424] on 14 June 2004 at 10:13:44 pm'!
SmartSyntaxInterpreterPlugin subclass: #ImmX11Plugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'Multilingual-ImmPlugin'!

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/8/2003 11:02'!
initialiseModule

	self export: true.
	^ true
! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/30/2003 04:49'!
primGetEncoding

	| ret array len |

	self export: true.
	self primitive: 'primGetEncoding'.
	self var: #len type: 'int'.
	self var: #array type: 'char *'.
	len _ self cCode: 'strlen(sqTextEncoding)'.

	ret _ interpreterProxy
			instantiateClass: interpreterProxy classString
			indexableSize: len.
	array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.	
	self cCode: 'strncpy(array, (char *)sqTextEncoding, len)'.
	
	^ ret.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 6/10/2004 21:24'!
primGetLocale

	| ret array len locale |

	self export: true.
	self primitive: 'primGetLocale'.
	self var: #len type: 'int'.
	self var: #array type: 'char *'.
	self var: #locale type: 'char *'.
	
	locale _ self cCode: 'setlocale(LC_CTYPE, "")'.
	(self cCode: 'locale')
		ifFalse: [ ret _ interpreterProxy nilObject ]
		ifTrue: [
			len _ self cCode: 'strlen(locale)'.
			ret _ interpreterProxy
				instantiateClass: interpreterProxy classString
				indexableSize: len.
			array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.
			self cCode: 'strncpy(array, (char *)locale, len)'.
		].	
	^ ret.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/30/2003 04:51'!
primGetLocaleEncoding

	| ret array len |

	self export: true.
	self primitive: 'primGetLocaleEncoding'.
	self var: #len type: 'int'.
	self var: #array type: 'char *'.

	(self cCode: '(int) localeEncoding')
		ifFalse: [ ret _ interpreterProxy nilObject ]
		ifTrue: [
			len _ self cCode: 'strlen(localeEncoding)'.
			ret _ interpreterProxy
				instantiateClass: interpreterProxy classString
				indexableSize: len.
			array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.
			self cCode: 'strncpy(array, (char *)localeEncoding, len)'.
		].	
	^ ret.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/5/2003 14:43'!
primGetPathEnc

	| ret array len |

	self export: true.
	self primitive: 'primGetPathEnc'.
	self var: #len type: 'int'.
	self var: #array type: 'char *'.
	len _ self cCode: 'strlen(uxPathEncoding)'.

	ret _ interpreterProxy
			instantiateClass: interpreterProxy classString
			indexableSize: len.
	array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.	
	self cCode: 'strncpy(array, (char *)uxPathEncoding, len)'.
	
	^ ret.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/30/2003 04:51'!
primGetTextEnc

	| ret array len |

	self export: true.
	self primitive: 'primGetTextEnc'.
	self var: #len type: 'int'.
	self var: #array type: 'char *'.
	len _ self cCode: 'strlen(uxTextEncoding)'.

	ret _ interpreterProxy
			instantiateClass: interpreterProxy classString
			indexableSize: len.
	array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.	
	self cCode: 'strncpy(array, (char *)uxTextEncoding, len)'.
	
	^ ret.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/1/2003 18:34'!
primGetXWinEnc

	| ret array len |

	self export: true.
	self primitive: 'primGetXWinEnc'.
	self var: #len type: 'int'.
	self var: #array type: 'char *'.
	len _ self cCode: 'strlen(uxXWinEncoding)'.

	ret _ interpreterProxy
			instantiateClass: interpreterProxy classString
			indexableSize: len.
	array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.	
	self cCode: 'strncpy(array, (char *)uxXWinEncoding, len)'.
	
	^ ret.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/28/2003 16:24'!
primIsTextEncUTF8

	self export: true.
	self primitive: 'primIsTextEncUTF8'.
	^ (self cCode: 'textEncodingUTF8') asOop: Boolean.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 4/13/2004 13:58'!
primSetCompositionFocus: bool

	| ret |
	self export: true.
	self primitive: 'primSetCompositionFocus'
		parameters: #(Boolean).
	
	ret _ self cCode: 'setCompositionFocus(bool)'.

	ret = false ifTrue: [
		interpreterProxy primitiveFail.
		^ nil
	].

	^ ret asOop: Boolean
! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 1/17/2004 08:14'!
primSetCompositionWindowPositionX: x y: y

	| ret |

	self export: true.
	self primitive: 'primSetCompositionWindowPosition'
		parameters: #(SmallInteger SmallInteger).
	

	ret _ self cCode: 'setCompositionWindowPosition(x, y)'.

	ret = false ifTrue: [
		interpreterProxy primitiveFail.
		^ nil
	].

	^ ret asOop: Boolean

! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/5/2003 14:42'!
primSetEncoding: encoding

	| name len |
	self export: true.
	self primitive: 'primSetEncoding'.
	self var: #name type: 'char *'.
	self var: #len type: 'size_t'.
	len _ interpreterProxy stSizeOf: encoding.
	name _ self cCoerce: (interpreterProxy firstIndexableField: encoding) to: 'char *'.
	self cCode: 'setNEncoding(&sqTextEncoding, name, len)'.
	^ encoding.
! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/30/2003 05:07'!
primSetEncodingToLocale

	| ret |
	self export: true.
	self primitive: 'primSetEncodingToLocale'.
	
	(self cCode: '(int) localeEncoding')
		ifFalse: [ ret _ interpreterProxy falseObject ] 
		ifTrue: [
			self cCode: 'sqTextEncoding = (void *)localeEncoding'.
			ret _ interpreterProxy trueObject
		].
	^ ret! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 6/14/2004 22:11'!
primSetLocale: locale

	| name len ret array |
	self export: true.
	self primitive: 'primSetLocale'.
	self var: #name type: 'char *'.
	self var: #array type: 'char *'.
	self var: #len type: 'size_t'.
	len _  interpreterProxy stSizeOf: locale.
	name _ self cCoerce: (interpreterProxy arrayValueOf: locale) to: 'char *'.
	name _ self cCode: 'setLocale(name, len)'.
	(self cCode: '(int) name')
		ifFalse: [^ interpreterProxy nilObject ]
		ifTrue: [
			len _ self cCode: 'strlen(name)'.
			ret _ interpreterProxy
				instantiateClass: interpreterProxy classString
				indexableSize: len.
			array _ self cCoerce: (interpreterProxy firstIndexableField: ret) to: 'char *'.
			self cCode: 'strncpy(array, (char *)name, len)'.
			^ ret ].
! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 6/8/2004 19:02'!
primSetLocaleEncoding: encoding

	| name len |
	self export: true.
	self primitive: 'primSetLocaleEncoding'.
	self var: #name type: 'char *'.
	self var: #len type: 'size_t'.
	len _ interpreterProxy stSizeOf: encoding.
	name _ self cCoerce: (interpreterProxy firstIndexableField: encoding) to: 'char *'.
	self cCode: 'setNEncoding(&localeEncoding, name, len)'.
	self cCode: 'sqTextEncoding= uxTextEncoding= uxPathEncoding= uxXWinEncoding= localeEncoding'.
	^ encoding.
! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/5/2003 14:40'!
primSetPathEnc: encoding

	| name len |
	self export: true.
	self primitive: 'primSetPathEnc'.
	self var: #name type: 'char *'.
	self var: #len type: 'size_t'.
	len _ interpreterProxy stSizeOf: encoding.
	name _ self cCoerce: (interpreterProxy firstIndexableField: encoding) to: 'char *'.
	self cCode: 'setNEncoding(&uxPathEncoding, name, len)'.
	^ encoding.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/5/2003 14:40'!
primSetPathEncToLocale

	| ret |
	self export: true.
	self primitive: 'primSetPathEncToLocale'.
	
	(self cCode: '(int) localeEncoding')
		ifFalse: [ ret _ interpreterProxy falseObject ] 
		ifTrue: [
			self cCode: 'uxPathEncoding = (void *)localeEncoding'.
			ret _ interpreterProxy trueObject
		].
	^ ret! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/5/2003 14:41'!
primSetTextEnc: encoding

	| name len |
	self export: true.
	self primitive: 'primSetTextEnc'.
	self var: #name type: 'char *'.
	self var: #len type: 'size_t'.
	len _ interpreterProxy stSizeOf: encoding.
	name _ self cCoerce: (interpreterProxy firstIndexableField: encoding) to: 'char *'.
	self cCode: 'setNEncoding(&uxTextEncoding, name, len)'.
	^ encoding.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/30/2003 05:08'!
primSetTextEncToLocale

	| ret |
	self export: true.
	self primitive: 'primSetTextEncToLocale'.
	
	(self cCode: '(int) localeEncoding')
		ifFalse: [ ret _ interpreterProxy falseObject ] 
		ifTrue: [
			self cCode: 'uxTextEncoding = (void *)localeEncoding'.
			ret _ interpreterProxy trueObject
		].
	^ ret! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/30/2003 05:13'!
primSetTextEncUTF8: bool

	self export: true.
	self primitive: 'primSetTextEncUTF8'
		parameters: #(Boolean).
	self cCode: 'textEncodingUTF8 = bool'.
	^ bool asOop: Boolean.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/5/2003 14:39'!
primSetXWinEnc: encoding

	| name len |
	self export: true.
	self primitive: 'primSetXWinEnc'.
	self var: #name type: 'char *'.
	self var: #len type: 'size_t'.
	len _ interpreterProxy stSizeOf: encoding.
	name _ self cCoerce: (interpreterProxy firstIndexableField: encoding) to: 'char *'.
	self cCode: 'setNEncoding(&uxXWinEncoding, name, len)'.
	^ encoding.! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 12/1/2003 18:35'!
primSetXWinEncToLocale

	| ret |
	self export: true.
	self primitive: 'primSetXWinEncToLocale'.
	
	(self cCode: '(int) localeEncoding')
		ifFalse: [ ret _ interpreterProxy falseObject ] 
		ifTrue: [
			self cCode: 'uxXWinEncoding = (void *)localeEncoding'.
			ret _ interpreterProxy trueObject
		].
	^ ret! !

!ImmX11Plugin methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 11/10/2003 21:58'!
shutdownModule

	self export: true.
	^ true
! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ImmX11Plugin class
	instanceVariableNames: ''!

!ImmX11Plugin class methodsFor: 'as yet unclassified' stamp: 'Tsutomu Hiroshima 6/14/2004 22:13'!
declareHeaderFilesIn: cg

	cg addHeaderFile: '<locale.h>'.
	cg addHeaderFile: '"sqUnixMain.h"'.
	cg addHeaderFile: '"sqUnixCharConv.h"', Character cr asString,
		'extern char *setLocale(char *, size_t);', Character cr asString,
		'extern int setCompositionWindowPosition(int, int);', Character cr asString,
		'extern int setCompostionFocus(int);'.! !
