'From Squeak3.9alpha of 4 July 2005 [latest update: #7021] on 14 April 2008 at 2:44:47 pm'!
SmartSyntaxInterpreterPlugin subclass: #SoundPlugin
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'VMMaker-Plugins'!
!SoundPlugin commentStamp: 'tpr 5/2/2003 15:50' prior: 0!
This plugin implements the main sound related primiives.  Since it requires platform support it will only be built when supported on your platform


FORMAT OF SOUND DATA

Squeak uses 16-bit signed samples encoded in the host's endian order.  A sound buffer is a sequence of "frames", or "slices", where each frame usually includes one sample per channel.  The exception is that for playback, each frame always includes 2 samples; for monaural playback, every other sample is ignored.
!


!SoundPlugin methodsFor: 'initialize-release' stamp: 'ar 5/12/2000 16:54'!
initialiseModule
	self export: true.
	^self cCode: 'soundInit()' inSmalltalk:[true]! !

!SoundPlugin methodsFor: 'initialize-release' stamp: 'ar 5/12/2000 16:55'!
shutdownModule
	self export: true.
	^self cCode: 'soundShutdown()' inSmalltalk:[true]! !


!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:11'!
primitiveSoundAvailableSpace
	"Returns the number of bytes of available sound output buffer space.  This should be (frames*4) if the device is in stereo mode, or (frames*2) otherwise"

	| frames |
	self primitive: 'primitiveSoundAvailableSpace'.
	frames := self cCode: 'snd_AvailableSpace()'.  "-1 if sound output not started"
	interpreterProxy success: frames >= 0.
	^frames asPositiveIntegerObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:10'!
primitiveSoundGetRecordingSampleRate
	"Return a float representing the actual sampling rate during recording. Fail if not currently recording."

	| rate |
	self var: #rate type: 'double '.
	self primitive: 'primitiveSoundGetRecordingSampleRate'.
	rate := self cCode: 'snd_GetRecordingSampleRate()'.  "fail if not recording"
	^rate asFloatObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'yo 10/19/2007 13:03'!
primitiveSoundGetSwitch: id capture: captureFlag channel: channel
	"Get the switch of device at id.  captureFlag specifies the direction of operation, and chennel specifies the channel of the device."
	| ret |
	self primitive: 'primitiveSoundGetSwitch'
		parameters: #(SmallInteger Boolean SmallInteger).
	interpreterProxy failed ifTrue: [^ nil].
	ret := self cCode: 'snd_GetSwitch(id, captureFlag, channel)'.
	ret < 0 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	^ ret asBooleanObj
! !

!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:11'!
primitiveSoundGetVolume
	"Set the sound input recording level."
	| left right results | 
	self primitive: 'primitiveSoundGetVolume'
		parameters: #( ).
	self var: #left type: 'double '.
	self var: #right type: 'double '.
	left := 0.
	right := 0.
	self cCode: 'snd_Volume((double *) &left,(double *) &right)'.
	interpreterProxy pushRemappableOop: (right asOop: Float).
	interpreterProxy pushRemappableOop: (left asOop: Float).
	interpreterProxy pushRemappableOop: (interpreterProxy instantiateClass: (interpreterProxy classArray) indexableSize: 2).
	results := interpreterProxy popRemappableOop.
	interpreterProxy storePointer: 0 ofObject: results withValue: interpreterProxy popRemappableOop.
	interpreterProxy storePointer: 1 ofObject: results withValue: interpreterProxy popRemappableOop.
	^ results! !

!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:10'!
primitiveSoundInsertSamples: frameCount from: buf leadTime: leadTime 
	"Insert a buffer's worth of sound samples into the currently playing  
	buffer. Used to make a sound start playing as quickly as possible. The  
	new sound is mixed with the previously buffered sampled."
	"Details: Unlike primitiveSoundPlaySamples, this primitive always starts  
	with the first sample the given sample buffer. Its third argument  
	specifies the number of samples past the estimated sound output buffer  
	position the inserted sound should start. If successful, it returns the  
	number of samples inserted."
	| framesPlayed |
	self primitive: 'primitiveSoundInsertSamples'
		parameters: #(SmallInteger WordArray SmallInteger ).
	interpreterProxy success: frameCount <= (interpreterProxy slotSizeOf: buf cPtrAsOop).

	interpreterProxy failed
		ifFalse: [framesPlayed := self cCode: 'snd_InsertSamplesFromLeadTime(frameCount, (int)buf, leadTime)'.
			interpreterProxy success: framesPlayed >= 0].
	^ framesPlayed asPositiveIntegerObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:10'!
primitiveSoundPlaySamples: frameCount from: buf startingAt: startIndex 
	"Output a buffer's worth of sound samples."
	| framesPlayed |
	self primitive: 'primitiveSoundPlaySamples'
		parameters: #(SmallInteger WordArray SmallInteger ).
	interpreterProxy success: (startIndex >= 1 and: [startIndex + frameCount - 1 <= (interpreterProxy slotSizeOf: buf cPtrAsOop)]).

	interpreterProxy failed
		ifFalse: [framesPlayed := self cCode: 'snd_PlaySamplesFromAtLength(frameCount, (int)buf, startIndex - 1)'.
			interpreterProxy success: framesPlayed >= 0].
	^ framesPlayed asPositiveIntegerObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:11'!
primitiveSoundPlaySilence
	"Output a buffer's worth of silence. Returns the number of sample frames played."

	| framesPlayed |
	self primitive: 'primitiveSoundPlaySilence'.
	framesPlayed := self cCode: 'snd_PlaySilence()'.  "-1 if sound output not started"
	interpreterProxy success: framesPlayed >= 0.
	^framesPlayed asPositiveIntegerObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'ar 4/4/2006 21:10'!
primitiveSoundRecordSamplesInto: buf startingAt: startWordIndex 
	"Record a buffer's worth of 16-bit sound samples."
	| bufSizeInBytes samplesRecorded |
	self primitive: 'primitiveSoundRecordSamples'
		parameters: #(WordArray SmallInteger ).

	interpreterProxy failed
		ifFalse: [bufSizeInBytes := (interpreterProxy slotSizeOf: buf cPtrAsOop) * 4.
			interpreterProxy success: (startWordIndex >= 1 and: [startWordIndex - 1 * 2 < bufSizeInBytes])].

	interpreterProxy failed ifFalse: [samplesRecorded := self cCode: 'snd_RecordSamplesIntoAtLength((int)buf, startWordIndex - 1, bufSizeInBytes)'].
	^ samplesRecorded asPositiveIntegerObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'yo 10/19/2007 15:45'!
primitiveSoundSetDevice: id name: deviceNameOop
	"Set the device slot specified by id with deviceName."
	| s buffer ret deviceName isArgNil |
	self primitive: 'primitiveSoundSetDevice'
		parameters: #(SmallInteger Oop).

	self cCode: '' inSmalltalk: [buffer := String new: 128].
	self var: 'deviceName' declareC: 'char *deviceName'.
	self var: 'buffer' declareC: 'char buffer[128]'.

	isArgNil := interpreterProxy nilObject == deviceNameOop.
	(isArgNil or: [interpreterProxy isBytes: deviceNameOop]) ifFalse: [
		self primitiveFail. ^ nil
	].

	(isArgNil not and: [(s := interpreterProxy stSizeOf: deviceNameOop) > 127]) ifTrue: [
		self primitiveFail. ^ nil
	].

	isArgNil ifFalse: [
		deviceName := interpreterProxy firstIndexableField: deviceNameOop.
		0 to: s - 1 do: [:i |
			buffer at: i put: (deviceName at: i)].
		buffer at: s put: 0.
		ret := self cCode: 'snd_SetDevice(id, buffer)'.
	] ifTrue: [
		ret := self cCode: 'snd_SetDevice(id, NULL)'.
	].
	
	ret < 0 ifTrue: [self primitiveFail. ^ nil].
	^ ret asBooleanObj! !

!SoundPlugin methodsFor: 'primitives' stamp: 'JMM 11/6/2000 11:06'!
primitiveSoundSetLeftVolume: aLeftVolume rightVolume: aRightVolume
	"Set the sound input recording level."

	self primitive: 'primitiveSoundSetLeftVolume'
		parameters: #(Float Float).
	interpreterProxy failed ifFalse: [self cCode: 'snd_SetVolume(aLeftVolume,aRightVolume)'].
! !

!SoundPlugin methodsFor: 'primitives' stamp: 'TPR 3/21/2000 16:39'!
primitiveSoundSetRecordLevel: level 
	"Set the sound input recording level."
	self primitive: 'primitiveSoundSetRecordLevel'
		parameters: #(SmallInteger ).
	interpreterProxy failed ifFalse: [self cCode: 'snd_SetRecordLevel(level)']! !

!SoundPlugin methodsFor: 'primitives' stamp: 'yo 10/19/2007 12:28'!
primitiveSoundSetSwitch: id capture: captureFlag parameter: parameter 
	"Set the switch of device at id.  captureFlag specifies the direction of operation, and parameter is the new value."
	| ret |
	self primitive: 'primitiveSoundSetSwitch'
		parameters: #(SmallInteger Boolean Boolean).
	interpreterProxy failed ifTrue: [^ nil].
	ret := self cCode: 'snd_SetSwitch(id, captureFlag, parameter)'.
	ret < 0 ifTrue: [interpreterProxy primitiveFail. ^ nil].
	^ ret asBooleanObj
! !

!SoundPlugin methodsFor: 'primitives' stamp: 'TPR 2/25/2000 14:58'!
primitiveSoundStartBufferSize: bufFrames rate: samplesPerSec stereo: stereoFlag
	"Start the double-buffered sound output with the given buffer size, sample rate, and stereo flag."

	self primitive: 'primitiveSoundStart'
		parameters: #(SmallInteger SmallInteger Boolean).
	interpreterProxy success: (self cCode: 'snd_Start(bufFrames, samplesPerSec, stereoFlag, 0)')! !

!SoundPlugin methodsFor: 'primitives' stamp: 'TPR 2/25/2000 12:57'!
primitiveSoundStartBufferSize: bufFrames rate: samplesPerSec stereo: stereoFlag semaIndex: semaIndex
	"Start the double-buffered sound output with the given buffer size, sample rate, stereo flag, and semaphore index."

	self primitive: 'primitiveSoundStartWithSemaphore'
		parameters: #(SmallInteger SmallInteger Boolean SmallInteger).
	interpreterProxy success: (self cCode: 'snd_Start(bufFrames, samplesPerSec, stereoFlag, semaIndex)')! !

!SoundPlugin methodsFor: 'primitives' stamp: 'TPR 2/25/2000 12:55'!
primitiveSoundStartRecordingDesiredSampleRate: desiredSamplesPerSec stereo: stereoFlag semaIndex: semaIndex
	"Start recording sound with the given parameters."

	self primitive: 'primitiveSoundStartRecording'
		parameters: #(SmallInteger Boolean SmallInteger).
	self cCode: 'snd_StartRecording(desiredSamplesPerSec, stereoFlag, semaIndex)'! !

!SoundPlugin methodsFor: 'primitives' stamp: 'TPR 2/25/2000 12:58'!
primitiveSoundStop
	"Stop double-buffered sound output."

	self primitive: 'primitiveSoundStop'.

	self cCode: 'snd_Stop()'.  "leave rcvr on stack"! !

!SoundPlugin methodsFor: 'primitives' stamp: 'TPR 2/25/2000 12:58'!
primitiveSoundStopRecording
	"Stop recording sound."

	self primitive: 'primitiveSoundStopRecording'.
	self cCode: 'snd_StopRecording()'.  "leave rcvr on stack"! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SoundPlugin class
	instanceVariableNames: ''!

!SoundPlugin class methodsFor: 'translation' stamp: 'tpr 5/23/2001 17:12'!
hasHeaderFile
	"If there is a single intrinsic header file to be associated with the plugin, here is where you want to flag"
	^true! !

!SoundPlugin class methodsFor: 'translation' stamp: 'tpr 11/29/2000 22:38'!
requiresPlatformFiles
	"this plugin requires platform specific files in order to work"
	^true! !
