/*
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.xml.stream.events ;

import javax.xml.stream.events.EndDocument;
import java.io.Writer;
import javax.xml.stream.XMLStreamConstants;

/**
 * This class contains information about EndDocument event.
 *
 * @author Neeraj Bajaj, Sun Microsystems.
 */


public class EndDocumentEvent extends DummyEvent
implements EndDocument {
    
    public EndDocumentEvent() {
        init();
    }
    
    protected void init() {
        setEventType(XMLStreamConstants.END_DOCUMENT);
    }
    
    public String toString() {
        return "ENDDOCUMENT";
    }
    
    /** This method will write the XMLEvent as per the XML 1.0 specification as Unicode characters.
     * No indentation or whitespace should be outputted.
     *
     * Any user defined event type SHALL have this method
     * called when being written to on an output stream.
     * Built in Event types MUST implement this method,
     * but implementations MAY choose not call these methods
     * for optimizations reasons when writing out built in
     * Events to an output stream.
     * The output generated MUST be equivalent in terms of the
     * infoset expressed.
     *
     * @param writer The writer that will output the data
     * @throws XMLStreamException if there is a fatal error writing the event
     */
    public void writeAsEncodedUnicode(Writer writer) throws javax.xml.stream.XMLStreamException {
    }
    
    
}
