/*
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.xml.stream.events ;

import java.util.List;
import java.util.ArrayList;

import javax.xml.namespace.QName;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import java.io.Writer;
import java.util.Iterator;
import javax.xml.stream.events.XMLEvent;
import com.sun.xml.stream.util.ReadOnlyIterator;

/** Implementation of EndElement event.
 *
 * @author Neeraj Bajaj Sun Microsystems,Inc.
 * @author K.Venugopal Sun Microsystems,Inc.
 */

public class EndElementEvent extends DummyEvent
implements EndElement {
    
    List fNamespaces = null;
    QName fQName ;
    
    public EndElementEvent() {
        init();
    }
    
    protected void init() {
        setEventType(XMLEvent.END_ELEMENT);
        fNamespaces = new ArrayList();
    }
    
    
    public EndElementEvent(String prefix,  String uri, String localpart) {
        this(new QName(uri,localpart,prefix));
    }
    
    public EndElementEvent(QName qname) {
        this.fQName = qname;
        init();
    }
    
    public QName getName() {
        return fQName;
    }
    
    public void setName(QName qname) {
        this.fQName = qname;
    }
    
    
    /** This method will write the XMLEvent as per the XML 1.0 specification as Unicode characters.
     * No indentation or whitespace should be outputted.
     *
     * Any user defined event type SHALL have this method
     * called when being written to on an output stream.
     * Built in Event types MUST implement this method,
     * but implementations MAY choose not call these methods
     * for optimizations reasons when writing out built in
     * Events to an output stream.
     * The output generated MUST be equivalent in terms of the
     * infoset expressed.
     *
     * @param writer The writer that will output the data
     * @throws XMLStreamException if there is a fatal error writing the event
     */
    public void writeAsEncodedUnicode(Writer writer) throws javax.xml.stream.XMLStreamException {
    }
    
    /** Returns an Iterator of namespaces that have gone out
     * of scope.  Returns an empty iterator if no namespaces have gone
     * out of scope.
     * @return an Iterator over Namespace interfaces, or an
     * empty iterator
     */
    public Iterator getNamespaces() {
        if(fNamespaces != null)
            fNamespaces.iterator();
        return new ReadOnlyIterator();
    }
    
    void addNamespace(Namespace attr){
        if(attr != null){
            fNamespaces.add(attr);
        }
    }
    
    public String toString() {
        String s = "</" + nameAsString();
        s = s + ">";
        return s;
    }
    
    public String nameAsString() {
        if("".equals(fQName.getNamespaceURI()))
            return fQName.getLocalPart();
        if(fQName.getPrefix() != null)
            return "['" + fQName.getNamespaceURI() + "']:" + fQName.getPrefix() + ":" + fQName.getLocalPart();
        else
            return "['" + fQName.getNamespaceURI() + "']:" + fQName.getLocalPart();
    }
    
}
