/**
 * Copyright 2004 Sun Microsystems, Inc. All rights reserved.
 * SUN PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 */

package com.sun.xml.stream.xerces.util;

import java.util.Enumeration;
import java.util.Vector;
import javax.xml.namespace.NamespaceContext ;


/**
 * Writing a wrapper to re-use most of the namespace functionality that has already been
 * provided by NamespaceContext.  NamespaceContext implements com.sun.xml.stream.xerces.xni.NamespaceContext
 * interface, It would be good if we can change XNI NamespaceContext interface to implement JAXP NamespaceContext
 * interface too.
 *
 * @author  Neeraj Bajaj, Sun Microsystems, inc.
 */
public class NamespaceContextWrapper implements NamespaceContext {
    
    private com.sun.xml.stream.xerces.xni.NamespaceContext fNamespaceContext ;
    
    /** Creates a new instance of NamespaceContextWrapper */
    public NamespaceContextWrapper(com.sun.xml.stream.xerces.xni.NamespaceContext namespaceContext) {
        fNamespaceContext = namespaceContext ;
    }
    
    public String getNamespaceURI(String prefix) {
        if(prefix == null){
            throw new IllegalArgumentException("Prefix can't be null");
        }
        return fNamespaceContext.getURI(prefix) ;
    }
    
    public String getPrefix(String namespaceURI) {
        if(namespaceURI == null || (namespaceURI.trim().length() == 0)){
            throw new IllegalArgumentException("URI can't be null or empty String");
        }
        return fNamespaceContext.getPrefix(namespaceURI) ;
    }
    
    //REVISIT: Namespace doesn't give information giving multiple prefixes for
    //the same namespaceURI.
    public java.util.Iterator getPrefixes(String namespaceURI) {
        if(namespaceURI == null || (namespaceURI.trim().length() == 0)){
            throw new IllegalArgumentException("URI can't be null or empty String");
        }
        else{
            //REVISIT: how to deal with this issue,
            //com.sun.xml.stream.xerces.xni.NamespaceContext getAllPrefixes() returns  Enumeration
            // and javax.xml.NamespaceContext requires iterator
            //OK, I have added getPrefixes() function in XNI NamespaceContext
            Vector vector = fNamespaceContext.getPrefixes(namespaceURI);
            return vector.iterator();
        }
    }//getPrefixes()
    
    //this function helps having support of all the different functions
    //in the NamespaceContext utility class.
    public com.sun.xml.stream.xerces.xni.NamespaceContext getNamespaceContext(){
        return fNamespaceContext ;
    }
}
