/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#include "vm_basic_types.h"
#include "vmcontrol.h"
#include "vmcontrol_constants.h"

typedef VMControlVM VMControlVM_Old;
typedef VMControlServer VMControlServer_Old; 

static int
not_here(char *s)
{
    croak("%s not implemented on this architecture", s);
    return -1;
}

static double
constant_VM_PO(char *name, int len, int arg)
{
    if (5 + 11 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[5 + 11]) {
    case 'H':
	if (strEQ(name + 5, "WEROP_MODE_HARD")) {	/* VM_PO removed */
#ifdef VM_POWEROP_MODE_HARD
	    return VM_POWEROP_MODE_HARD;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 5, "WEROP_MODE_SOFT")) {	/* VM_PO removed */
#ifdef VM_POWEROP_MODE_SOFT
	    return VM_POWEROP_MODE_SOFT;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 5, "WEROP_MODE_TRYSOFT")) {	/* VM_PO removed */
#ifdef VM_POWEROP_MODE_TRYSOFT
	    return VM_POWEROP_MODE_TRYSOFT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PRODINFO_VERSION_M(char *name, int len, int arg)
{
    switch (name[21 + 0]) {
    case 'A':
	if (strEQ(name + 21, "AJOR")) {	/* VM_PRODINFO_VERSION_M removed */
#ifdef VM_PRODINFO_VERSION_MAJOR
	    return VM_PRODINFO_VERSION_MAJOR;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 21, "INOR")) {	/* VM_PRODINFO_VERSION_M removed */
#ifdef VM_PRODINFO_VERSION_MINOR
	    return VM_PRODINFO_VERSION_MINOR;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PRODINFO_V(char *name, int len, int arg)
{
    if (13 + 7 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[13 + 7]) {
    case 'M':
	if (!strnEQ(name + 13,"ERSION_", 7))
	    break;
	return constant_VM_PRODINFO_VERSION_M(name, len, arg);
    case 'R':
	if (strEQ(name + 13, "ERSION_REVISION")) {	/* VM_PRODINFO_V removed */
#ifdef VM_PRODINFO_VERSION_REVISION
	    return VM_PRODINFO_VERSION_REVISION;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PRODINFO_P(char *name, int len, int arg)
{
    switch (name[13 + 0]) {
    case 'L':
	if (strEQ(name + 13, "LATFORM")) {	/* VM_PRODINFO_P removed */
#ifdef VM_PRODINFO_PLATFORM
	    return VM_PRODINFO_PLATFORM;
#else
	    goto not_there;
#endif
	}
    case 'R':
	if (strEQ(name + 13, "RODUCT")) {	/* VM_PRODINFO_P removed */
#ifdef VM_PRODINFO_PRODUCT
	    return VM_PRODINFO_PRODUCT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PRODI(char *name, int len, int arg)
{
    if (8 + 4 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[8 + 4]) {
    case 'B':
	if (strEQ(name + 8, "NFO_BUILD")) {	/* VM_PRODI removed */
#ifdef VM_PRODINFO_BUILD
	    return VM_PRODINFO_BUILD;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (!strnEQ(name + 8,"NFO_", 4))
	    break;
	return constant_VM_PRODINFO_P(name, len, arg);
    case 'V':
	if (!strnEQ(name + 8,"NFO_", 4))
	    break;
	return constant_VM_PRODINFO_V(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PRODU(char *name, int len, int arg)
{
    if (8 + 3 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[8 + 3]) {
    case 'E':
	if (strEQ(name + 8, "CT_ESX")) {	/* VM_PRODU removed */
#ifdef VM_PRODUCT_ESX
	    return VM_PRODUCT_ESX;
#else
	    goto not_there;
#endif
	}
    case 'G':
	if (strEQ(name + 8, "CT_GSX")) {	/* VM_PRODU removed */
#ifdef VM_PRODUCT_GSX
	    return VM_PRODUCT_GSX;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 8, "CT_UNKNOWN")) {	/* VM_PRODU removed */
#ifdef VM_PRODUCT_UNKNOWN
	    return VM_PRODUCT_UNKNOWN;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 8, "CT_WS")) {	/* VM_PRODU removed */
#ifdef VM_PRODUCT_WS
	    return VM_PRODUCT_WS;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PR(char *name, int len, int arg)
{
    if (5 + 2 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[5 + 2]) {
    case 'I':
	if (!strnEQ(name + 5,"OD", 2))
	    break;
	return constant_VM_PRODI(name, len, arg);
    case 'U':
	if (!strnEQ(name + 5,"OD", 2))
	    break;
	return constant_VM_PRODU(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_PL(char *name, int len, int arg)
{
    if (5 + 7 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[5 + 7]) {
    case 'L':
	if (strEQ(name + 5, "ATFORM_LINUX")) {	/* VM_PL removed */
#ifdef VM_PLATFORM_LINUX
	    return VM_PLATFORM_LINUX;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 5, "ATFORM_UNKNOWN")) {	/* VM_PL removed */
#ifdef VM_PLATFORM_UNKNOWN
	    return VM_PLATFORM_UNKNOWN;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 5, "ATFORM_VMNIX")) {	/* VM_PL removed */
#ifdef VM_PLATFORM_VMNIX
	    return VM_PLATFORM_VMNIX;
#else
	    goto not_there;
#endif
	}
    case 'W':
	if (strEQ(name + 5, "ATFORM_WINDOWS")) {	/* VM_PL removed */
#ifdef VM_PLATFORM_WINDOWS
	    return VM_PLATFORM_WINDOWS;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_P(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'L':
	return constant_VM_PL(name, len, arg);
    case 'O':
	return constant_VM_PO(name, len, arg);
    case 'R':
	return constant_VM_PR(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_NOT(char *name, int len, int arg)
{
    switch (name[8 + 0]) {
    case 'C':
	if (strEQ(name + 8, "CONNECTED")) {	/* VM_E_NOT removed */
#ifdef VM_E_NOTCONNECTED
	    return VM_E_NOTCONNECTED;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 8, "SUPPORTED")) {	/* VM_E_NOT removed */
#ifdef VM_E_NOTSUPPORTED
	    return VM_E_NOTSUPPORTED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_NO(char *name, int len, int arg)
{
    switch (name[7 + 0]) {
    case 'A':
	if (strEQ(name + 7, "ACCESS")) {	/* VM_E_NO removed */
#ifdef VM_E_NOACCESS
	    return VM_E_NOACCESS;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 7, "EXECVMAUTHD")) {	/* VM_E_NO removed */
#ifdef VM_E_NOEXECVMAUTHD
	    return VM_E_NOEXECVMAUTHD;
#else
	    goto not_there;
#endif
	}
    case 'M':
	if (strEQ(name + 7, "MEM")) {	/* VM_E_NO removed */
#ifdef VM_E_NOMEM
	    return VM_E_NOMEM;
#else
	    goto not_there;
#endif
	}
    case 'P':
	if (strEQ(name + 7, "PROPERTY")) {	/* VM_E_NO removed */
#ifdef VM_E_NOPROPERTY
	    return VM_E_NOPROPERTY;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 7, "SUCHVM")) {	/* VM_E_NO removed */
#ifdef VM_E_NOSUCHVM
	    return VM_E_NOSUCHVM;
#else
	    goto not_there;
#endif
	}
    case 'T':
	return constant_VM_E_NOT(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_NE(char *name, int len, int arg)
{
    switch (name[7 + 0]) {
    case 'E':
	if (strEQ(name + 7, "EDINPUT")) {	/* VM_E_NE removed */
#ifdef VM_E_NEEDINPUT
	    return VM_E_NEEDINPUT;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 7, "TFAIL")) {	/* VM_E_NE removed */
#ifdef VM_E_NETFAIL
	    return VM_E_NETFAIL;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_N(char *name, int len, int arg)
{
    switch (name[6 + 0]) {
    case 'E':
	return constant_VM_E_NE(name, len, arg);
    case 'O':
	return constant_VM_E_NO(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_B(char *name, int len, int arg)
{
    if (6 + 2 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[6 + 2]) {
    case 'R':
	if (strEQ(name + 6, "ADRESPONSE")) {	/* VM_E_B removed */
#ifdef VM_E_BADRESPONSE
	    return VM_E_BADRESPONSE;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 6, "ADSTATE")) {	/* VM_E_B removed */
#ifdef VM_E_BADSTATE
	    return VM_E_BADSTATE;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 6, "ADVERSION")) {	/* VM_E_B removed */
#ifdef VM_E_BADVERSION
	    return VM_E_BADVERSION;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_V(char *name, int len, int arg)
{
    if (6 + 1 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[6 + 1]) {
    case 'B':
	if (strEQ(name + 6, "MBUSY")) {	/* VM_E_V removed */
#ifdef VM_E_VMBUSY
	    return VM_E_VMBUSY;
#else
	    goto not_there;
#endif
	}
    case 'E':
	if (strEQ(name + 6, "MEXISTS")) {	/* VM_E_V removed */
#ifdef VM_E_VMEXISTS
	    return VM_E_VMEXISTS;
#else
	    goto not_there;
#endif
	}
    case 'I':
	if (strEQ(name + 6, "MINITFAILED")) {	/* VM_E_V removed */
#ifdef VM_E_VMINITFAILED
	    return VM_E_VMINITFAILED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_I(char *name, int len, int arg)
{
    if (6 + 6 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[6 + 6]) {
    case 'A':
	if (strEQ(name + 6, "NVALIDARGS")) {	/* VM_E_I removed */
#ifdef VM_E_INVALIDARGS
	    return VM_E_INVALIDARGS;
#else
	    goto not_there;
#endif
	}
    case 'C':
	if (strEQ(name + 6, "NSUFFICIENT_RESOURCES")) {	/* VM_E_I removed */
#ifdef VM_E_INSUFFICIENT_RESOURCES
	    return VM_E_INSUFFICIENT_RESOURCES;
#else
	    goto not_there;
#endif
	}
    case 'V':
	if (strEQ(name + 6, "NVALIDVM")) {	/* VM_E_I removed */
#ifdef VM_E_INVALIDVM
	    return VM_E_INVALIDVM;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E_(char *name, int len, int arg)
{
    switch (name[5 + 0]) {
    case 'A':
	if (strEQ(name + 5, "ALREADYCONNECTED")) {	/* VM_E_ removed */
#ifdef VM_E_ALREADYCONNECTED
	    return VM_E_ALREADYCONNECTED;
#else
	    goto not_there;
#endif
	}
    case 'B':
	return constant_VM_E_B(name, len, arg);
    case 'D':
	if (strEQ(name + 5, "DISCONNECT")) {	/* VM_E_ removed */
#ifdef VM_E_DISCONNECT
	    return VM_E_DISCONNECT;
#else
	    goto not_there;
#endif
	}
    case 'G':
	if (strEQ(name + 5, "GARBAGE")) {	/* VM_E_ removed */
#ifdef VM_E_GARBAGE
	    return VM_E_GARBAGE;
#else
	    goto not_there;
#endif
	}
    case 'I':
	return constant_VM_E_I(name, len, arg);
    case 'N':
	return constant_VM_E_N(name, len, arg);
    case 'P':
	if (strEQ(name + 5, "PROXYFAIL")) {	/* VM_E_ removed */
#ifdef VM_E_PROXYFAIL
	    return VM_E_PROXYFAIL;
#else
	    goto not_there;
#endif
	}
    case 'S':
	if (strEQ(name + 5, "SUCCESS")) {	/* VM_E_ removed */
#ifdef VM_E_SUCCESS
	    return VM_E_SUCCESS;
#else
	    goto not_there;
#endif
	}
    case 'T':
	if (strEQ(name + 5, "TIMEOUT")) {	/* VM_E_ removed */
#ifdef VM_E_TIMEOUT
	    return VM_E_TIMEOUT;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 5, "UNSPECIFIED")) {	/* VM_E_ removed */
#ifdef VM_E_UNSPECIFIED
	    return VM_E_UNSPECIFIED;
#else
	    goto not_there;
#endif
	}
    case 'V':
	return constant_VM_E_V(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_EXECUTION_STATE_O(char *name, int len, int arg)
{
    switch (name[20 + 0]) {
    case 'F':
	if (strEQ(name + 20, "FF")) {	/* VM_EXECUTION_STATE_O removed */
#ifdef VM_EXECUTION_STATE_OFF
	    return VM_EXECUTION_STATE_OFF;
#else
	    goto not_there;
#endif
	}
    case 'N':
	if (strEQ(name + 20, "N")) {	/* VM_EXECUTION_STATE_O removed */
#ifdef VM_EXECUTION_STATE_ON
	    return VM_EXECUTION_STATE_ON;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_EXECUTION_STATE_S(char *name, int len, int arg)
{
    switch (name[20 + 0]) {
    case 'T':
	if (strEQ(name + 20, "TUCK")) {	/* VM_EXECUTION_STATE_S removed */
#ifdef VM_EXECUTION_STATE_STUCK
	    return VM_EXECUTION_STATE_STUCK;
#else
	    goto not_there;
#endif
	}
    case 'U':
	if (strEQ(name + 20, "USPENDED")) {	/* VM_EXECUTION_STATE_S removed */
#ifdef VM_EXECUTION_STATE_SUSPENDED
	    return VM_EXECUTION_STATE_SUSPENDED;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_EX(char *name, int len, int arg)
{
    if (5 + 14 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[5 + 14]) {
    case 'O':
	if (!strnEQ(name + 5,"ECUTION_STATE_", 14))
	    break;
	return constant_VM_EXECUTION_STATE_O(name, len, arg);
    case 'S':
	if (!strnEQ(name + 5,"ECUTION_STATE_", 14))
	    break;
	return constant_VM_EXECUTION_STATE_S(name, len, arg);
    case 'U':
	if (strEQ(name + 5, "ECUTION_STATE_UNKNOWN")) {	/* VM_EX removed */
#ifdef VM_EXECUTION_STATE_UNKNOWN
	    return VM_EXECUTION_STATE_UNKNOWN;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant_VM_E(char *name, int len, int arg)
{
    switch (name[4 + 0]) {
    case 'X':
	return constant_VM_EX(name, len, arg);
    case '_':
	return constant_VM_E_(name, len, arg);
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}

static double
constant(char *name, int len, int arg)
{
    errno = 0;
    if (0 + 3 >= len ) {
	errno = EINVAL;
	return 0;
    }
    switch (name[0 + 3]) {
    case 'E':
	if (!strnEQ(name + 0,"VM_", 3))
	    break;
	return constant_VM_E(name, len, arg);
    case 'P':
	if (!strnEQ(name + 0,"VM_", 3))
	    break;
	return constant_VM_P(name, len, arg);
    case 'T':
	if (strEQ(name + 0, "VM_TIMEOUT_ID_DEFAULT")) {	/*  removed */
#ifdef VM_TIMEOUT_ID_DEFAULT
	    return VM_TIMEOUT_ID_DEFAULT;
#else
	    goto not_there;
#endif
	}
    }
    errno = EINVAL;
    return 0;

not_there:
    errno = ENOENT;
    return 0;
}


/*
 * Stub allocators: Results from the VMControl library are allocated and must be
 * freed by the VmPerl wrappers.  To make sure that the memory allocated by
 * VMControl can be freed in VmPerl, pass to VMControl the allocators it should
 * use.  Otherwise, we run into cases where the heaps used by VmPerl and VMControl
 * are different and VmPerl is unable to free the memory.
 */

void *
VMControlPerlMalloc(size_t size)
{
   return malloc(size);
}
void *
VMControlPerlCalloc(size_t n, size_t size)
{
   return calloc(n, size);
}
void
VMControlPerlFree(void *buf)
{
   free(buf);
}

VMControlInitParameters vmcontrolPerlAllocators = {
   VMControlPerlMalloc,
   VMControlPerlCalloc,
   VMControlPerlFree,
};


MODULE = VMware::VmPerl		PACKAGE = VMware::VmPerl		PREFIX = VMControl_
PROTOTYPES: ENABLE

Bool
VMControl_Init()

void
VMControl_InitMemoryRoutines()
        CODE:
        VMControl_SetMemoryRoutines(&vmcontrolPerlAllocators);

const char *
VMControl_Version()

const char *
VMControl_GetErrorMessage(err)
        int     err

double
constant(sv,arg)
    PREINIT:
	STRLEN		len;
    INPUT:
	SV *		sv
	char *		s = SvPV(sv, len);
	int		arg
    CODE:
	RETVAL = constant(s,len,arg);
    OUTPUT:
	RETVAL


#################################################################################
#
# VMware::VmPerl::ConnectParams
#
#################################################################################

MODULE = VMware::VmPerl		PACKAGE = VMware::VmPerl::ConnectParams		PREFIX = VMControl_ConnectParams
PROTOTYPES: ENABLE

VMControlConnectParams *
VMControl_ConnectParamsNew(hostname, port, username, password)
	const char *	hostname
	int	port
	const char *	username
	const char *	password

void
VMControl_ConnectParamsDESTROY(params)
        VMControlConnectParams *params
        CODE:
        VMControl_ConnectParamsDestroy(params);

const char *
VMControl_ConnectParamsGetHostname(params)
        VMControlConnectParams *params
        CODE:
        RETVAL = params->hostname;
        OUTPUT:
        RETVAL

void
VMControl_ConnectParamsSetHostname(params, hostname)
        VMControlConnectParams *params
        const char * hostname
        CODE:
        if (hostname) {
          if (params->hostname) {
            free((char *) params->hostname);
          }
          params->hostname = strdup(hostname);
        }

const char *
VMControl_ConnectParamsGetUsername(params)
        VMControlConnectParams *params
        CODE:
        RETVAL = params->username;
        OUTPUT:
        RETVAL

void
VMControl_ConnectParamsSetUsername(params, username)
        VMControlConnectParams *params
        const char * username
        CODE:
        if (username) {
          if (params->username) {
            free((char *) params->username);
          }
          params->username =  strdup(username);
        }

const char *
VMControl_ConnectParamsGetPassword(params)
        VMControlConnectParams *params
        CODE:
        RETVAL = params->password;
        OUTPUT:
        RETVAL

void
VMControl_ConnectParamsSetPassword(params, password)
        VMControlConnectParams *params
        const char * password
        CODE:
        if (password) {
          if (params->password) {
            free((char *) params->password);
          }
          params->password = strdup(password);
        }

int
VMControl_ConnectParamsGetPort(params)
        VMControlConnectParams *params
        CODE:
        RETVAL = params->port;
        OUTPUT:
        RETVAL

void
VMControl_ConnectParamsSetPort(params, port)
        VMControlConnectParams *params
        int port
        CODE:
        params->port = port;

#################################################################################
#
# VMware::VmPerl::Question
#
#################################################################################

MODULE = VMware::VmPerl		PACKAGE = VMware::VmPerl::Question		PREFIX = VMControl_Question
PROTOTYPES: ENABLE

void
VMControl_QuestionDESTROY(q)
	VMControlExternalQuestion *	q
        CODE:
        VMControl_VMDestroyExternalQuestion(q);

int
VMControl_QuestionGetId(q)
        VMControlExternalQuestion *     q
        CODE:
        RETVAL = q->id;
        OUTPUT:
        RETVAL

char *
VMControl_QuestionGetText(q)
	VMControlExternalQuestion *	q
        CODE:
        RETVAL = q->text;
        OUTPUT:
        RETVAL

char **
VMControl_QuestionGetChoices(q)
	VMControlExternalQuestion *	q
        PREINIT:
        int i;
        PPCODE:
        for (i=0; q->choices[i]; i++) {
           XPUSHs(sv_2mortal(newSVpv(q->choices[i], 0)));
        }



#################################################################################
#
# VMware::VmPerl::Server
#
#################################################################################

MODULE = VMware::VmPerl		PACKAGE = VMware::VmPerl::Server		PREFIX = VMControl_Server
PROTOTYPES: ENABLE

Bool
VMControl_ServerInit()

VMControlServer *
VMControl_ServerNew()
        CODE:       
        RETVAL = VMControl_ServerNewEx();
        OUTPUT:
        RETVAL

void
VMControl_ServerDESTROY(s)
	VMControlServer *	s
        CODE:
        VMControl_ServerDestroy(s);

void
VMControl_ServerDisconnect(s)
       VMControlServer *      s

Bool
VMControl_ServerConnect(s, c)
        VMControlServer *      s
        VMControlConnectParams *      c
        CODE:
        RETVAL = VMControl_ServerConnectEx(s, c);
        OUTPUT:
        RETVAL

Bool
VMControl_ServerIsConnected(s)
        VMControlServer *      s

char **
VMControl_ServerEnumerate(s)
	VMControlServer *	s
        PREINIT:
        char **x, **x_sav;
        PPCODE:
        x_sav = x = VMControl_ServerEnumerate(s);
        if (x) {
          while(*x) {
            XPUSHs(sv_2mortal(newSVpv(*x, 0)));
            free(*x);
            x++;
          }
          free (x_sav);
        } else {
           XSRETURN_UNDEF;
        }

int
VMControl_ServerGetLastError(s)
        VMControlServer *       s
        PREINIT:
        int retval;
        char * string;
        PPCODE:
        retval = VMControl_ServerGetLastError(s, &string);
        XPUSHs(sv_2mortal(newSViv((IV) retval)));
        XPUSHs(sv_2mortal(newSVpv(string, 0)));
        if (string) free(string);

Bool
VMControl_ServerRegister(s, configpath)
        VMControlServer *      s
        const char *    configpath

Bool
VMControl_ServerUnregister(s, configpath)
        VMControlServer *      s
        const char *    configpath

Bool
VMControl_ServerIsRegistered(s, configpath)
        VMControlServer *      s
        const char *    configpath
        PREINIT:
        Bool retval;
        Bool isRegistered;
        PPCODE:
        retval = VMControl_ServerIsRegistered(s, configpath, &isRegistered);
        XPUSHs(sv_2mortal(boolSV(retval)));
        XPUSHs(sv_2mortal(newSViv((IV) isRegistered)));

int
VMControl_ServerGetTimeout(s)
        VMControlServer *      s

int
VMControl_ServerSetTimeout(s, timeout)
        VMControlServer *      s
        int                    timeout

char *
VMControl_ServerGetResource(s, key)
        VMControlServer *    s 
        char *               key
        PREINIT:
        char* result;
        CODE:
        result = VMControl_ServerGetResource(s, key);
        if (result) {
            RETVAL = result;
        } else {
            XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_ServerSetResource(s, key, newVal)
        VMControlServer *   s 
        char *              key
        char *              newVal



#################################################################################
#
# VMware::VmPerl::VM
#
#################################################################################

MODULE = VMware::VmPerl		PACKAGE = VMware::VmPerl::VM		PREFIX = VMControl_VM
PROTOTYPES: ENABLE

Bool
VMControl_VMInit()

void
VMControl_VMDESTROY(vm)
	VMControlVM *	vm
        CODE:
        VMControl_VMDestroy(vm);

void
VMControl_VMDisconnect(vm)
        VMControlVM *    vm

Bool
VMControl_VMConnect(vm, cp, cfg)
        VMControlVM *            vm
        VMControlConnectParams * cp
        const char *             cfg
        CODE:
        RETVAL = VMControl_VMConnectEx(vm, cp, cfg, 0);
        OUTPUT:
        RETVAL

Bool
VMControl_VMIsConnected(vm)
        VMControlVM *      vm

Bool
VMControl_VMExit(vm)
	VMControlVM *	vm

int
VMControl_VMGetLastError(vm)
        VMControlVM *   vm
        PREINIT:
        int retval;
        char * string;
        PPCODE:
        retval = VMControl_VMGetLastError(vm, &string);
        XPUSHs(sv_2mortal(newSViv((IV) retval)));
        XPUSHs(sv_2mortal(newSVpv(string, 0)));
        if(string) free(string);

void
VMControl_VMSetError(vm, err, str)
	VMControlVM *	vm
        int             err
	const char *	str


VMControlVM *
VMControl_VMNew()
        CODE:       
        RETVAL = VMControl_VMNewEx();
        OUTPUT:
        RETVAL

Bool
VMControl_VMReset(vm, mode)
	VMControlVM *	vm
	int mode
        CODE:
        RETVAL = VMControl_VMStopOrReset(vm, FALSE, mode);
        OUTPUT:
        RETVAL

Bool
VMControl_VMStart(vm, mode)
	VMControlVM *	vm
        int mode

Bool
VMControl_VMStop(vm, mode)
	VMControlVM *	vm
	int mode
        CODE:
        RETVAL = VMControl_VMStopOrReset(vm, TRUE, mode);
        OUTPUT:
        RETVAL

Bool
VMControl_VMSuspendToDisk(vm, mode)
	VMControlVM *	vm
        int mode

Bool
VMControl_VMDeviceConnect(vm, device)
	VMControlVM *	vm
	const char *	device

Bool
VMControl_VMDeviceDisconnect(vm, device)
	VMControlVM *	vm
	const char *	device

Bool
VMControl_VMDeviceIsConnected(vm, device)
        VMControlVM *	vm
	const char *	device
        PREINIT:
        Bool connected;
        Bool result;
        CODE:
        result = VMControl_VMDeviceIsConnected(vm, device, &connected);
        if (result) {
           RETVAL = connected;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

Bool
VMControl_VMCommit(vm, disk, level, freeze, wait)
	VMControlVM *	vm
	const char *	disk
	int level
	int freeze
	int wait

Bool
VMControl_VMAddRedo(vm, disk)
	VMControlVM *	vm
	const char *	disk


int
VMControl_VMGetExecutionState(vm)
        VMControlVM *	vm
        PREINIT:
        int state;
        Bool result;
        CODE:
        result = VMControl_VMGetExecutionState(vm, &state);
        if (result) {
           RETVAL = state;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

VMControlExternalQuestion *
VMControl_VMGetExternalQuestion(vm)
        VMControlVM *	vm

Bool
VMControl_VMAnswerQuestion(vm, q, choice)
	VMControlVM *	vm
	VMControlExternalQuestion *q
	int choice
        CODE:
        if (q) {
           RETVAL = VMControl_VMAnswerQuestion(vm, q->id, choice);
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

char *
VMControl_VMGetGuestInfo(vm, key)
        VMControlVM *    vm 
        char *           key
        PREINIT:
        char* result;
        CODE:
        result = VMControl_VMGetGuestInfo(vm, key);
        if (result) {
            RETVAL = result;
        } else {
            XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_VMSetGuestInfo(vm, key, newVal)
        VMControlVM *    vm 
        char *           key
        char *           newVal

char *
VMControl_VMGetConfig(vm, key)
        VMControlVM *    vm 
        char *           key
        PREINIT:
        char* result;
        CODE:
        result = VMControl_VMGetConfig(vm, key);
        if (result) {
            RETVAL = result;
        } else {
            XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_VMSetConfig(vm, key, newVal)
        VMControlVM *    vm 
        char *           key
        char *           newVal

char *
VMControl_VMGetResource(vm, key)
        VMControlVM *    vm 
        char *           key
        PREINIT:
        char* result;
        CODE:
        result = VMControl_VMGetResource(vm, key);
        if (result) {
            RETVAL = result;
        } else {
            XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_VMSetResource(vm, key, newVal)
        VMControlVM *    vm 
        char *           key
        char *           newVal

int
VMControl_VMGetHeartbeat(vm)
        VMControlVM *    vm
        PREINIT:
        int heartbeat;
        Bool result;
        CODE:
        result = VMControl_VMGetHeartbeat(vm, &heartbeat);
        if (result) {
           RETVAL = heartbeat;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMGetUptime(vm)
        VMControlVM *    vm
        PREINIT:
        int uptime;
        Bool result;
        CODE:
        result = VMControl_VMGetUptime(vm, &uptime);
        if (result) {
           RETVAL = uptime;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMGetId(vm)
        VMControlVM *    vm
        PREINIT:
        int id;
        Bool result;
        CODE:
        result = VMControl_VMGetId(vm, &id);
        if (result) {
           RETVAL = id;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMGetPid(vm)
        VMControlVM *    vm
        PREINIT:
        int pid;
        Bool result;
        CODE:
        result = VMControl_VMGetPid(vm, &pid);
        if (result) {
           RETVAL = pid;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMGetCapabilities(vm)
        VMControlVM *    vm
        PREINIT:
        int capabilities;
        Bool result;
        CODE:
        result = VMControl_VMGetCapabilities(vm, &capabilities);
        if (result) {
           RETVAL = capabilities;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMGetRemoteConnections(vm)
        VMControlVM *    vm
        PREINIT:
        int numConnections;
        Bool result;
        CODE:
        result = VMControl_VMGetRemoteConnections(vm, &numConnections);
        if (result) {
           RETVAL = numConnections;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMToolsLastActive(vm)
        VMControlVM *vm
        PREINIT:
        int seconds;
        Bool result;
        CODE:
        result = VMControl_VMToolsLastActive(vm, &seconds);
        if (result) {
           RETVAL = seconds;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

int
VMControl_VMGetProductInfo(vm, infotype)
        VMControlVM *     vm
        int               infotype
        PREINIT:
        int value;
        Bool result;
        CODE:
        result = VMControl_VMGetProductInfo(vm, infotype, &value);
        if (result) {
           RETVAL = value;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

char *
VMControl_VMGetConfigFileName(vm)
        VMControlVM *    vm 
        CLEANUP:
        if (RETVAL) free(RETVAL);

int
VMControl_VMGetTimeout(vm, timeoutId)
        VMControlVM *   vm
        int             timeoutId
        PREINIT:
        int value;
        Bool result;
        CODE:
        result = VMControl_VMAccessTimeout(vm, timeoutId, NULL, &value);
        if (result) {
           RETVAL = value;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

Bool
VMControl_VMSetTimeout(vm, timeoutId, newTimeout)
        VMControlVM *   vm
        int             timeoutId
        int             newTimeout
        PREINIT:
        Bool result;
        CODE:
        result = VMControl_VMAccessTimeout(vm, timeoutId, &newTimeout, NULL);
        if (result) {
           RETVAL = result;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

char **
VMControl_VMWho(vm)
        VMControlVM *  vm
        PREINIT:
        char **x, **x_sav;
        PPCODE:
        x_sav = x = VMControl_VMWho(vm);
        if (x) {
          while(*x) {
            XPUSHs(sv_2mortal(newSVpv(*x, 0)));
            free(*x);
            x++;
          }
          free (x_sav);
        } else {
          XSRETURN_UNDEF;
        }

Bool
VMControl_VMCreateSnapshot(vm)
        VMControlVM *vm
        PREINIT:
        Bool result;
        CODE:
        result = VMControl_VMCreateSnapshot(vm);
        RETVAL = result;
        OUTPUT:
        RETVAL


Bool
VMControl_VMHasSnapshot(vm)
        VMControlVM *vm
        PREINIT:
        Bool result;
        Bool hasSnapshot;
        CODE:
        result = VMControl_VMHasSnapshot(vm, &hasSnapshot);
        if (result) {
           RETVAL = hasSnapshot;        
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL


Bool
VMControl_VMRevertSnapshot(vm)
        VMControlVM *vm
        PREINIT:
        Bool result;
        CODE:
        result = VMControl_VMRevertSnapshot(vm);
        RETVAL = result;
        OUTPUT:
        RETVAL


Bool
VMControl_VMDeleteSnapshot(vm)
        VMControlVM *vm
        PREINIT:
        Bool result;
        CODE:
        result = VMControl_VMDeleteSnapshot(vm);
        RETVAL = result;
        OUTPUT:
        RETVAL

Bool
VMControl_VMSetRunAsUser(vm, username, password, checkValid)
        VMControlVM *vm
        const char *username
        const char *password
        Bool checkValid
        PREINIT:
        Bool result;
        CODE:
        result = VMControl_VMSetRunAsUser(vm, username, password, checkValid);
        RETVAL = result;
        OUTPUT:
        RETVAL

char *
VMControl_VMGetRunAsUser(vm)
        VMControlVM *vm
        PREINIT:
        char *username;
        Bool result;
        CODE:
        result = VMControl_VMGetRunAsUser(vm, &username);
        if (result) {
            RETVAL = username;
        } else {
            XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL
        CLEANUP:
        if (RETVAL) free(RETVAL);


#################################################################################
#
# VMware::VmPerl::VM : FOR INTERNAL TESTING ONLY.
#
#################################################################################

char *
VMControl_VMGetAsString(vm, var)
	VMControlVM *	vm
	const char *	var
        CLEANUP:
        if (RETVAL) free(RETVAL);

char *
VMControl_VMGetAsStringServerd(vm, var)
	VMControlVM *	vm
	const char *	var
        CLEANUP:
        if (RETVAL) free(RETVAL);







#################################################################################
# LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY 
#################################################################################
#
# VMware::Control : For backwards-compatability with legacy APIs. 
#                   Will be eventually phased out.
#
#################################################################################
# LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY  LEGACY 
#################################################################################


MODULE = VMware::Control		PACKAGE = VMware::Control		PREFIX = VMControl_
PROTOTYPES: ENABLE

const char *
VMControl_GetErrorMessage(err)
        int     err

int
VMControl_GetDefaultTCPPort()

void
VMControl_InitMemoryRoutines()
        CODE:
        VMControl_SetMemoryRoutines(&vmcontrolPerlAllocators);

MODULE = VMware::Control		PACKAGE = VMware::Control::Server		PREFIX = VMControl_Server
PROTOTYPES: ENABLE

Bool
VMControl_ServerInit()

void
VMControl_ServerDESTROY(s)
	VMControlServer_Old *	s
        CODE:
        VMControl_ServerDestroy(s);

void
VMControl_ServerDisconnect(s)
       VMControlServer_Old *      s

Bool
VMControl_ServerConnect(s)
        VMControlServer_Old *      s

Bool
VMControl_ServerIsConnected(s)
        VMControlServer_Old *      s

char **
VMControl_ServerEnumerate(s)
	VMControlServer_Old *	s
        PREINIT:
        char **x, **x_sav;
        PPCODE:
        x_sav = x = VMControl_ServerEnumerate(s);
        if (x) {
          while(*x) {
            XPUSHs(sv_2mortal(newSVpv(*x, 0)));
            free(*x);
            x++;
          }
          free (x_sav);
        } else {
           XSRETURN_UNDEF;
        }

char *
VMControl_ServerExec(s, xmlargs)
	VMControlServer_Old *	s
	const char *	xmlargs
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_ServerShutdown(s)
	VMControlServer_Old *	s

int
VMControl_ServerGetLastError(s)
        VMControlServer_Old *       s
        PREINIT:
        int retval;
        char * string;
        PPCODE:
        retval = VMControl_ServerGetLastError(s, &string);
        XPUSHs(sv_2mortal(newSViv((IV) retval)));
        XPUSHs(sv_2mortal(newSVpv(string, 0)));
        if (string) free(string);

VMControlServer_Old *
VMControl_ServerNew(hostname, port, username, password)
	const char *	hostname
	int	port
	const char *	username
	const char *	password

Bool
VMControl_ServerRegister(s, configpath)
        VMControlServer_Old *      s
        const char *    configpath

Bool
VMControl_ServerUnregister(s, configpath)
        VMControlServer_Old *      s
        const char *    configpath

Bool
VMControl_ServerIsRegistered(s, configpath)
        VMControlServer_Old *      s
        const char *    configpath
        PREINIT:
        Bool retval;
        Bool isRegistered;
        PPCODE:
        retval = VMControl_ServerIsRegistered(s, configpath, &isRegistered);
        XPUSHs(sv_2mortal(boolSV(retval)));
        XPUSHs(sv_2mortal(newSViv((IV) isRegistered)));

Bool
VMControl_ServerTest(s, query)
        VMControlServer_Old *      s
        const char *    query

char *
VMControl_ServerGetAsString(s, query)
	VMControlServer_Old *	s
	const char *	    query
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_ServerSetAsString(s, key, value)
        VMControlServer_Old *      s
	const char *         key
	const char *       value

int
VMControl_ServerGetTimeout(s)
        VMControlServer_Old *      s

int
VMControl_ServerSetTimeout(s, timeout)
        VMControlServer_Old *      s
        int               timeout

MODULE = VMware::Control		PACKAGE = VMware::Control::VM		PREFIX = VMControl_VM
PROTOTYPES: ENABLE

Bool
VMControl_VMInit()

void
VMControl_VMDESTROY(vm)
	VMControlVM_Old *	vm
        CODE:
        VMControl_VMDestroy(vm);

void
VMControl_VMDisconnect(vm)
        VMControlVM_Old *    vm

Bool
VMControl_VMConnect(vm, mks)
        VMControlVM_Old *      vm
        int     mks

Bool
VMControl_VMIsConnected(vm)
        VMControlVM_Old *      vm

Bool
VMControl_VMAnswerQuestion(vm, sequence, choicenum)
        VMControlVM_Old *   vm
        int     sequence
        int     choicenum

Bool
VMControl_VMExit(vm)
	VMControlVM_Old *	vm

char *
VMControl_VMGetAsString(vm, var)
	VMControlVM_Old *	vm
	const char *	var
        CLEANUP:
        if (RETVAL) free(RETVAL);

char *
VMControl_VMGetAsStringServerd(vm, var)
	VMControlVM_Old *	vm
	const char *	var
        CLEANUP:
        if (RETVAL) free(RETVAL);

Bool
VMControl_VMSetAsString(vm, var, value)
	VMControlVM_Old *	vm
	const char *	var
	const char *	value

int
VMControl_VMGetLastError(vm)
        VMControlVM_Old *   vm
        PREINIT:
        int retval;
        char * string;
        PPCODE:
        retval = VMControl_VMGetLastError(vm, &string);
        XPUSHs(sv_2mortal(newSViv((IV) retval)));
        XPUSHs(sv_2mortal(newSVpv(string, 0)));
        if(string) free(string);

void
VMControl_VMSetError(vm, err, str)
	VMControlVM_Old *	vm
    int             err
	const char *	str


char **
VMControl_VMInfo(s)
	VMControlVM_Old *	s
        PREINIT:
        char **x, **x_sav;
        PPCODE:
        x_sav = x = VMControl_VMInfo(s);
        if (x) {
          while(*x) {
                XPUSHs(sv_2mortal(newSVpv(*x, 0)));
                x++;
                if(*x) {
                        XPUSHs(sv_2mortal(newSVpv(*x, 0)));
                } else {
                        XPUSHs(&PL_sv_undef);
                }
                free(*x);
                x++;
          }
          free(x_sav);
        }

VMControlVM_Old *
VMControl_VMNew(s, config)
	VMControlServer_Old *	s
	const char *	config

Bool
VMControl_VMRequestReset(vm, force)
	VMControlVM_Old *	vm
	int force

Bool
VMControl_VMReset(vm, force)
	VMControlVM_Old *	vm
	int force

Bool
VMControl_VMStart(vm, mode)
	VMControlVM_Old *	vm
        int mode

Bool
VMControl_VMRequestStop(vm, force)
	VMControlVM_Old *	vm
	int force

Bool
VMControl_VMStop(vm, force)
	VMControlVM_Old *	vm
	int force

Bool
VMControl_VMSuspendToDisk(vm, mode)
	VMControlVM_Old *	vm
        int mode

char **
VMControl_VMWho(vm)
	VMControlVM_Old *	vm
        PREINIT:
        char **x, **x_sav;
        PPCODE:
        x_sav = x = VMControl_VMWho(vm);
        if (x) {
          while(*x) {
            XPUSHs(sv_2mortal(newSVpv(*x, 0)));
            free(*x);
            x++;
          }
          free (x_sav);
        }

Bool
VMControl_VMReloadConfig(vm)
	VMControlVM_Old *	vm

Bool
VMControl_VMSetConfigChanges(vm, ...)
	VMControlVM_Old *	vm
        PREINIT:
        const char * *list;
        int i;
        CODE:
        list = malloc(items * sizeof(char *));
        for (i = 0; i < items - 1; i++) {
                list[i] = (char *) SvPV(ST(i+1), PL_na);
        
        }
        list[i] = NULL;
        RETVAL = VMControl_VMSetConfigChanges(vm, list);
        free((char *)list);

Bool
VMControl_VMSaveConfig(vm)
	VMControlVM_Old *	vm

Bool
VMControl_VMDeviceConnect(vm, device)
	VMControlVM_Old *	vm
	const char *	device

Bool
VMControl_VMDeviceDisconnect(vm, device)
	VMControlVM_Old *	vm
	const char *	device

Bool
VMControl_VMDeviceIsConnected(vm, device)
        VMControlVM_Old *	vm
	const char *	device
        PREINIT:
        Bool connected;
        Bool result;
        CODE:
        result = VMControl_VMDeviceIsConnected(vm, device, &connected);
        if (result) {
           RETVAL = connected;
        } else {
           XSRETURN_UNDEF;
        }
        OUTPUT:
        RETVAL

Bool
VMControl_VMToolsInstallBegin(vm)
	VMControlVM_Old *	vm

Bool
VMControl_VMToolsInstallEnd(vm)
	VMControlVM_Old *	vm

Bool
VMControl_VMCommit(vm, disk, level, freeze, wait)
	VMControlVM_Old *	vm
	const char *	disk
	int level
	int freeze
	int wait

Bool
VMControl_VMAddRedo(vm, disk)
	VMControlVM_Old *	vm
	const char *	disk

int
VMControl_VMGetTimeout(vm)
        VMControlVM_Old *   vm

int
VMControl_VMSetTimeout(vm, timeout)
        VMControlVM_Old *   vm
        int             timeout

MODULE = VMware::Control		PACKAGE = VMware::Control::VM		PREFIX = VMControl_MKS
PROTOTYPES: ENABLE

#ifndef DISABLE_VMCONTROL_MKS

Bool
VMControl_MKSInsertKeyEvent(vm, scancode, down)
        VMControlVM_Old *   vm
        int     scancode
        int     down

Bool
VMControl_MKSSaveScreenshot(vm, filename, fileType)
        VMControlVM_Old *   vm
	const char *	filename
	const char *	fileType

int
VMControl_MKSMatchScreenshot(vm, timeout)
	VMControlVM_Old *	vm
	int	timeout

Bool
VMControl_MKSTargetScreenshot(vm, filename, maskFilename, fileType, maskFileType, tolerance)
	VMControlVM_Old *	vm
	const char *	filename
	const char *	maskFilename
	const char *	fileType
	const char *	maskFileType
	int	tolerance


#endif

MODULE = VMware::Control		PACKAGE = VMware::Control::Profiler		PREFIX = VMControl_Profiler
PROTOTYPES: ENABLE

unsigned long
VMControl_ProfilerGetTime()




# without line below, xs generates boot__VMWare_Control instead

MODULE = VMware::VmPerl		PACKAGE = VMware::VmPerl		PREFIX = VMControl_


