/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

/*
 * includeCheck.h --
 *
 *	Restrict include file use.
 *
 * In every .h file, define one or more of these
 *
 *	INCLUDE_ALLOW_VMX 
 *	INCLUDE_ALLOW_USERLEVEL 
 *	INCLUDE_ALLOW_MONITOR 
 *	INCLUDE_ALLOW_MODULE 
 *	INCLUDE_ALLOW_VMKERNEL 
 *	INCLUDE_ALLOW_DISTRIBUTE
 *	INCLUDE_ALLOW_VMK_MODULE
 *
 * Then include this file.
 *
 * Any file that has INCLUDE_ALLOW_DISTRIBUTE defined will potentially
 * be distributed in source form along with GPLed code.  Ensure
 * that this is acceptable.
 */

#if defined VMX86_VMX && \
    !(defined INCLUDE_ALLOW_VMX || defined INCLUDE_ALLOW_USERLEVEL)
#error "The surrounding include file is not allowed in the VMX."
#endif
#undef INCLUDE_ALLOW_VMX

#if defined USERLEVEL && !defined VMX86_VMX && \
    !defined INCLUDE_ALLOW_USERLEVEL
#error "The surrounding include file is not allowed at userlevel."
#endif
#undef INCLUDE_ALLOW_USERLEVEL

/*
 * At this time, and for historical reasons, MONITOR is
 * defined when compiling a private part of the monitor
 * which in particular does not include the devices.  In
 * addition, VMM is also defined when compiling the other
 * components of the "vmm" binary (pretty much just the
 * devices).
 */

#if !defined MONITOR && defined VMM
#error Yo! This is not allowed, fix your makefiles.
#endif

#if defined MONITOR && !defined INCLUDE_ALLOW_MONITOR && \
        !defined INCLUDE_ALLOW_VMM
#error "The surrounding include file is not allowed in the monitor."
#endif
#undef INCLUDE_ALLOW_MONITOR

#if defined VMM && !defined INCLUDE_ALLOW_VMM
#error "The surrounding include file is not allowed in the vmm."
#endif
#undef INCLUDE_ALLOW_VMM

#if defined MODULE && !defined VMKERNEL_MODULE && !defined INCLUDE_ALLOW_MODULE
#error "The surrounding include file is not allowed in driver modules."
#endif
#undef INCLUDE_ALLOW_MODULE

#if defined VMKERNEL && !defined INCLUDE_ALLOW_VMKERNEL
#error "The surrounding include file is not allowed in the vmkernel."
#endif
#undef INCLUDE_ALLOW_VMKERNEL

#if defined GPLED_CODE && !defined INCLUDE_ALLOW_DISTRIBUTE
#error "The surrounding include file is not allowed in GPL code."
#endif
#undef INCLUDE_ALLOW_DISTRIBUTE

#if defined VMKERNEL_MODULE && !defined VMKERNEL && \
    !defined INCLUDE_ALLOW_VMK_MODULE
#error "The surrounding include file is not allowed in vmkernel modules."
#endif
#undef INCLUDE_ALLOW_VMK_MODULE
