#!/usr/bin/perl -w

#############################################################
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#############################################################

#
# Query.pm
# 
# Query VM state.
#

package VMware::VMServerd::Query;
  
use strict;
use Carp;
use VMware::DOMAccess;
use VMware::VMServerd;
use VMware::Control::VM;
use VMware::VMServerd::VMList;
use VMware::VMServerd::Stats;
use VMware::VMServerd qw(Warning);

# Parses a query and returns the results in
# a comma delimited list.  This function is
# the serverd equivalent of MstatsQuery()
#
# XXX: As we get more complicated stats, we should
# probably move to a lookup table, rather than nested ifs
sub QueryStats($$$) {
  my $vm = shift;
  my $device = shift;
  my $query = shift;
  my $id = "SYSTEM";
  my $ret = undef;

  if ($device ne "system") {
     $id = $vm->get("Status.id");
  }

  if ($device eq "devices") {
     # XXX the stats module currently only supports vm & system stats
     $ret =  "vm,system";
  }
  elsif ($query eq "stats") {
     $ret =  &VMware::VMServerd::Stats::GetStatsList($id);
     } 
  elsif ($query =~ m/^([^\.]*)$/) {
     my @result  = &VMware::VMServerd::Stats::getLastSample($id, "$device.$1");
     $ret =  $result[1];
  }

  #XXX Need to add support for interval query mode

  #XXX Info node not supported by Stats.pm
  #if ($query =~ m/Status\.stats\.vm\.(.*)\.info/) {
  #}


  return $ret;
}

# Serverd_Get
#
# Queries serverd.  If serverd doesn't have the
# information (ie the query is not a stat), then 
# return an empty string / or undef is returned
sub Serverd_Get($$) {
    my $cfg = shift;
    my $query = shift;
    my $vm = VMware::VMServerd::findVM($cfg);
    my $ret = undef;

    if (!defined($vm)) {
       Warning("couldn't find vm for $cfg and $query");
       return "";
    }

    if ($query =~ m/Status\.stats\.(vm|system|devices)\.?(.*)/) {
       $ret =  QueryStats($vm,$1,$2);
    }

    return $ret;
}
1;
