/* **********************************************************
 * Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
 * **********************************************************/

#ifndef _VMCONTROL_CONSTANTS_H_
#define _VMCONTROL_CONSTANTS_H_

#define VM_TIMEOUT_ID_FIRST   1
#define VM_TIMEOUT_ID_DEFAULT 1
#define VM_TIMEOUT_ID_LAST    1

#define VM_EXECUTION_STATE_FIRST     1
#define VM_EXECUTION_STATE_ON        1
#define VM_EXECUTION_STATE_OFF       2
#define VM_EXECUTION_STATE_SUSPENDED 3
#define VM_EXECUTION_STATE_STUCK     4
#define VM_EXECUTION_STATE_UNKNOWN   5
#define VM_EXECUTION_STATE_LAST      5

#define VM_POWEROP_MODE_FIRST      1
#define VM_POWEROP_MODE_HARD       1
#define VM_POWEROP_MODE_SOFT       2
#define VM_POWEROP_MODE_TRYSOFT    3
#define VM_POWEROP_MODE_LAST       3

#define VM_PRODUCT_FIRST      1
#define VM_PRODUCT_WS         1
#define VM_PRODUCT_GSX        2
#define VM_PRODUCT_ESX        3
#define VM_PRODUCT_UNKNOWN    4
#define VM_PRODUCT_LAST       4

#define VM_PLATFORM_FIRST     1
#define VM_PLATFORM_WINDOWS   1
#define VM_PLATFORM_LINUX     2
#define VM_PLATFORM_VMNIX     3
#define VM_PLATFORM_UNKNOWN   4
#define VM_PLATFORM_LAST      4

#define VM_PRODINFO_FIRST            1
#define VM_PRODINFO_PRODUCT          1
#define VM_PRODINFO_PLATFORM         2
#define VM_PRODINFO_BUILD            3
#define VM_PRODINFO_VERSION_MAJOR    4
#define VM_PRODINFO_VERSION_MINOR    5
#define VM_PRODINFO_VERSION_REVISION 6
#define VM_PRODINFO_LAST             6


#define VM_E_SUCCESS            0  // Operation succeeded
#define VM_E_NOMEM             -1  // Could not allocate memory
#define VM_E_NETFAIL           -2  // Network failure, or could not connect
                                   // to remote host
#define VM_E_INVALIDARGS       -3  // Invalid arguments
#define VM_E_NOACCESS          -4  // Permission denied for this operation
#define VM_E_NOTCONNECTED      -5  // The VMserver or VM struct is invalid
                                   // (there is no connection established when
                                   // there should be)
#define VM_E_BADVERSION        -6  // Version mismatch with vmauthd or VMX
#define VM_E_TIMEOUT           -7  // Timeout talking to vmauthd or VMX
#define VM_E_BADSTATE          -8 // The operation is not valid for the current
                                  // state the VM is in (e.g. Stop() on a
                                  // powered off machine)
#define VM_E_NOEXECVMAUTHD     -9  // Could not exec vmauthd (locally)
#define VM_E_NOPROPERTY       -10  // No such property
#define VM_E_NOSUCHVM         -11  // No such VM
#define VM_E_ALREADYCONNECTED -12  // Already connected
#define VM_E_DISCONNECT       -13  // Connection lost
#define VM_E_BADRESPONSE      -14  // Unexpected response from VMAuthd
#define VM_E_GARBAGE          -15  // Garbage received on connection
                                   // VMAuthd protocol error
#define VM_E_NEEDINPUT        -16  // The VM needs the user to answer
                                   // a question
#define VM_E_NOTSUPPORTED     -17  // Operation is not supported by the server
#define VM_E_INVALIDVM        -18  // VM config file is invalid
#define VM_E_VMINITFAILED     -19  // Failed to initialize the VM
#define VM_E_VMEXISTS         -20  // VM already exists
#define VM_E_VMBUSY           -21  // VM is unavailable
#define VM_E_INSUFFICIENT_RESOURCES   -22  // A resource limit was exceeded 
#define VM_E_PROXYFAIL        -23  // Failed to connect to proxy
#define VM_E_POLICYFINALIZEFAILED -24 // Failed to finalize policies
#define VM_E_NEWVERSIONVM     -25  // VM is newer than supoorted by the platform

#define VM_E_UNSPECIFIED  -999  // Unknown error XXX should get rid of these


#endif

