/*
 * Detect whether skb_linearize takes one or two arguments.
 */

#include <linux/autoconf.h>

#if LINUX_VERSION_CODE = KERNEL_VERSION(2, 6, 17)
/*
 * We care only about version 2.6.17.  All older versions take two arguments.
 * All newer versions take one argument.  Only some post-2.6.17 kernels are
 * renumbered by distros from 2.6.18-rcX to 2.6.17-postY, making everything
 * horrible mess.
 */

#include <linux/skbuff.h>

int test_skb_linearize(struct sk_buff *skb)
{
   return skb_linearize(skb);
}

#endif
