#
# Copyright 2004 VMware, Inc.  All rights reserved. -- VMware Confidential
#

package VMware::VmdbPerl::Debug;

use strict;
use Exporter();

use vars qw(@ISA @EXPORT @EXPORT_OK);

@ISA = qw(Exporter);

@EXPORT_OK = qw(&DumpList
                &DumpSchema
                &DumpGet
                );


# Preloaded methods go here.

sub Print {
   print @_;
}

sub DumpList {
   my $ctx = shift;
   my $path = shift;

   my $child = $ctx->GetFirstChild($path);
   if ($child) {
      Print($child . "\n");
   }
   while (defined($child = $ctx->GetNextSibling($child))) {
      Print($child . "\n");
   }
}

sub DumpSchema {
   my $ctx = shift;
   my $path = shift;

   my $child = $ctx->GetFirstChild($path);
   if ($child) {
      Print("$path\n");
      DumpSchema($ctx, $child);
   } else {
      return;
   }

   while (defined($child = $ctx->GetNextSibling($child))) {
      if ($child !~ m=/#?#[^#/]+/=) {
         Print("$child\n");
         DumpSchema($ctx, $child);
      }
   }
}

sub DumpGet {
   my $ctx = shift;
   my $path = shift;
   my $maxLevel = shift;
   my $level = shift;

   if (!defined($level)) {
      $level = 0;
   } elsif (defined($maxLevel) && $maxLevel > 0) {
      if ($level > $maxLevel) {
         return;
      }
   }

   my $child = $ctx->GetFirstChild($path);
   if ($child) {
      Print("$path\n");
      if ($child !~ m=/#?#/=) {
         DumpGet($ctx, $child, $maxLevel, $level + 1);
      }
   } else {
      my $val = $ctx->GetString($path);
      if (!defined($val)) {
         $val = "";
      }
      Print("$path = \"$val\"\n");
      return;
   }

   while (defined($child = $ctx->GetNextSibling($child))) {
      DumpGet($ctx, $child, $maxLevel, $level + 1);
   }
}

# Autoload methods go after =cut, and are processed by the autosplit program.

1;

__END__

=head1 NAME

Debug - Debug utilities for VMDB Perl extension.

=head1 SYNOPSIS


=head1 DESCRIPTION


=head1 Exported constants


=head1 Exported functions


=head1 AUTHOR


=head1 SEE ALSO

perl(1).

=cut

