use ExtUtils::MakeMaker;
use Config;

# See lib/ExtUtils/MakeMaker.pm for details of how to influence
# the contents of the Makefile that is written.

# To make: type "perl Makefile.PL; make" in this directory.
# To check if things worked correctly, try running "make test"

my %args = (
    'NAME'		=> 'VMware::VmPerl',
    'VERSION_FROM'	=> 'VmPerl/VmPerl.pm', # finds $VERSION
    'PREREQ_PM'		=> {}, # e.g., Module::Name => 1.1
    'LIBS'		=> [''], # e.g., '-lm'
    'DEFINE'		=> '', # e.g., '-DHAVE_SOMETHING'
    'INC'		=> '', # e.g., '-I/usr/include/other'

#Perl 5.005_03 (RedHat 6.1 and 6.2) automatically uses these
#    'CCFLAGS'		=> '-Dbool=char -DHAS_BOOL -I/usr/local/include',
#    'OPTIMIZE'		=> '-O2',

    'MYEXTLIB'          => ($^O ne "MSWin32" ?
                              (($Config{archname} =~ /^(x86_64|amd64)-/) ?
                                'vmcontrol64.o' : 'vmcontrol.o') :
                            'vmcontrollib.lib'),

    'PM'        => {'Control.pm' => '$(INST_LIBDIR)/Control.pm',
                    'Server.pm' => '$(INST_LIBDIR)/Control/Server.pm',
                    'Keycode.pm' => '$(INST_LIBDIR)/Control/Keycode.pm',
                    'VMScript.pm' => '$(INST_LIBDIR)/Control/VMScript.pm',
                    'VM.pm'     => '$(INST_LIBDIR)/Control/VM.pm',
                    'Profiler.pm' => '$(INST_LIBDIR)/Control/Profiler.pm',

                    'VmPerl/VmPerl.pm' => '$(INST_LIBDIR)/VmPerl.pm',
                    'VmPerl/Server.pm' => '$(INST_LIBDIR)/VmPerl/Server.pm',
                    'VmPerl/VM.pm'     => '$(INST_LIBDIR)/VmPerl/VM.pm',
                    'VmPerl/Question.pm'     => '$(INST_LIBDIR)/VmPerl/Question.pm',
                    'VmPerl/ConnectParams.pm' => '$(INST_LIBDIR)/VmPerl/ConnectParams.pm'
                     },

    'MAN3PODS'  => {'VmPerl/VmPerl.pm' => '$(INST_MAN3DIR)/VMware::VmPerl.$(MAN3EXT)',
                    'VmPerl/Server.pm' => '$(INST_MAN3DIR)/VMware::VmPerl::Server.$(MAN3EXT)',
                    'VmPerl/VM.pm'     => '$(INST_MAN3DIR)/VMware::VmPerl::VM.$(MAN3EXT)',
                    'VmPerl/Question.pm' => '$(INST_MAN3DIR)/VMware::VmPerl::Question.$(MAN3EXT)',
                    'VmPerl/ConnectParams.pm' => 
                          '$(INST_MAN3DIR)/VMware::VmPerl::ConnectParams.$(MAN3EXT)'
                     }
            );

my $gcc_version;
# If during build, use specified gcc; if during installation/configuration,
# use the default gcc on the local machine. 
if (defined($ENV{VMWARE_CC})) {
   $gcc_version = `sh -c \""$ENV{VMWARE_CC}" --version\"`;
} else {
   $gcc_version = `gcc --version`;
}
chomp($gcc_version);

if (defined($^V) && $^V eq v5.6.0 && $gcc_version eq "2.7.2.3") {
#Perl 5.6.0 requires these w/ gcc 2.7.2.3 or we get compiler errors 
    $args{'CCFLAGS'} = '-D_LARGEFILE_SOURCE -D_FILE_OFFSET_BITS=64';
    $args{'OPTIMIZE'} = '-O3 -fomit-frame-pointer -fno-rtti -pipe -s -ffast-math -fexpensive-optimizations';
}
 
WriteMakefile(%args);

sub MY::post_constants {
   my $self = shift;

   if ($^O ne "MSWin32") {
      return <<END_TEXT;

LDLOADLIBS = $ENV{LD_LIBS}
LDDLFLAGS = -shared $ENV{LD_OPTS}

END_TEXT
   }
}

sub MY::postamble {
   if ($^O ne "MSWin32") {
      return <<END_TEXT;

ifndef VERBOSE
.SILENT:
endif

END_TEXT
   }
}
