#
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#

package VMware::VmPerl::Question;

use strict;
use Carp;

require DynaLoader;

use vars qw($VERSION @ISA);

BEGIN{$VERSION = '1.01'};

@ISA = qw(DynaLoader);

use VMware::VmPerl $VERSION;

# Preloaded methods go here.

sub get_text 
{
   my $q = shift;

   my $ret = $q->GetText();

   if ($ret) {
      return $ret;
   } else {
      return undef;
   }
}

sub get_id 
{
   my $q = shift;

   my $ret = $q->GetId();

   if ($ret) {
      return $ret;
   } else {
      return undef;
   }
}

sub get_choices 
{
   my $q = shift;

   my @choices = $q->GetChoices();
   if ($#choices >= 0) {
      return @choices;
   } else {
      return undef;
   }
}

__END__

=head1 NAME

VMware::VmPerl::Question - Question object

=head1 SYNOPSIS

TBA

=head1 DESCRIPTION

Encapsulates an interactive question from a VM.

=head1 VMware::VmPerl::Question

=head2 $question->get_text()

  Gets the question's descriptive text.

=head2 $question->get_choices()

  Gets an array of strings representing the different answer choices. 

=head2 $question->get_id()

  Gets an integer internally used to identify the question.

=head1 AUTHORS

Jeff Hu, Vui-Chiap Lam, Bich Le

=head1 COPYRIGHT

    (c) 2002 VMware Incorporated.  All rights reserved.

=head1 VERSION

Version 1.01	   29 Mar 2002

C<% pod2html --header --title="VMware::VmPerl::Question" E<lt> Question.pm E<gt> Question.html>

=head1 SEE ALSO

perl(1).

=cut
