/*
 * nopage prototype changed in 2.6.1.  For 2.6.2 and newer assume
 * it uses new prototype.  For 2.6.1 (and its -rc) and older do
 * compile test.
 */
#include <linux/autoconf.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 2)
#include <linux/mm.h>

static struct page *LinuxDriverNoPage(struct vm_area_struct *vma,
                           unsigned long address, int *type) {
	(void)vma;
	(void)address;
	*type = VM_FAULT_MAJOR;
	return NULL;
}

struct vm_operations_struct vmuser_mops = {
        .nopage = LinuxDriverNoPage
};
#endif
