/* **********************************************************
 * Copyright (C) 2007 VMware, Inc.  All Rights Reserved. -- VMware Confidential
 * **********************************************************/

/*
 * Detect whether nf_hookfn takes struct sk_buff* skb, or struct sk_buff** pskb.
 * Kernels before 2.6.23 take pskb, kernels since 2.6.24 take skb, and we
 * are not sure about 2.6.23 itself, as change occured between 2.6.23 and
 * 2.6.24-rc1.
 */

#include <linux/autoconf.h>
#include <linux/version.h>

#if LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 23)
#   error This compile test intentionally fails.
#elif LINUX_VERSION_CODE < KERNEL_VERSION(2, 6, 24)
#   include <linux/netfilter.h>

nf_hookfn test_function;

unsigned int
test_function(unsigned int hooknum,
              struct sk_buff *skb,
	      const struct net_device *in,
	      const struct net_device *out,
	      int (*defn)(struct sk_buff*))
{
   return 1234;
}
#endif
