#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to 
# your agreement to the terms of an applicable VMware license.
#

package VMware::Vix::API::Job;

#use 5.00503;
use strict;
use Carp;

use VMware::VixBinding;
require Exporter;
require DynaLoader;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
@ISA = qw(Exporter DynaLoader);

%EXPORT_TAGS = ( 'all' => [ qw(
   Wait
   CheckCompletion
   GetError

   WaitTimeout
) ] );

@EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
@EXPORT = qw();

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

sub WaitTimeout {
   my $jobHandle = shift;
   my $time = shift;
   my $complete = 0;
   my $err;

   while ($time gt 0) {
      $err = CheckCompletion($jobHandle, $complete);
      last if $complete;
      $time -= 1;
      sleep(1);
   }

   $err = CheckCompletion($jobHandle, $complete);

   return ($complete, $err, $time);
}

1;
__END__
