#
# Copyright 2006.  VMware, Inc.  The use of this code is subject to 
# your agreement to the terms of an applicable VMware license.
#

package VMware::Vix::API::VM;

#use 5.00503;
use strict;
use Carp;

use VMware::VixBinding;
require Exporter;
require DynaLoader;

use vars qw(@ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
@ISA = qw(Exporter DynaLoader);

%EXPORT_TAGS = ( 'all' => [ qw(
   Open
   Delete
   PowerOn
   PowerOff
   Reset
   Suspend

   GetNumRootSnapshots
   GetRootSnapshot
   RemoveSnapshot
   RevertToSnapshot
   CreateSnapshot

   WaitForToolsInGuest
   UpgradeVirtualHardware
   InstallTools

   LoginInGuest
   RunProgramInGuest
   CopyFileFromHostToGuest
   CopyFileFromGuestToHost
) ] );

@EXPORT_OK = ( @{ $EXPORT_TAGS{'all'} } );
@EXPORT = qw();

# Preloaded methods go here.

# Autoload methods go after =cut, and are processed by the autosplit program.

1;
__END__
