#!/usr/bin/perl -w

#############################################################
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#############################################################
#
# CommonConstant.pm
# 
# A class that contains the constants needed by the host configuration
# module, and are common to both GSX and ESX.
#
# XXX This file should be integrated with Constant.pm more closely
# so there is no need to duplicate the code as we do here currently. -dilip
#
package VMware::HConfig::CommonConstant;
use strict;

if ($^O ne "MSWin32") {
require VMware::HConfig;
}

use Exporter   ();
use vars       qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);
use VMware::ExtHelpers qw(Panic Warning);

BEGIN {
    # set the version for version checking
    $VERSION     = 1.00;
    @ISA         = qw(Exporter);
    @EXPORT_OK   = qw(c_getProductName
		      c_getHelper
		      c_getFile
		      c_getDir
		      @VMX_CFG_EXTENSIONS
		      @VMX_STD_EXTENSIONS
		      );
}

use vars qw(@VMX_CFG_EXTENSIONS
	    @VMX_STD_EXTENSIONS
	    );

# List of the valid file extensions
@VMX_CFG_EXTENSIONS = ('vmx', 'cfg');
@VMX_STD_EXTENSIONS = ('vmss', 'std');

my %gFiles = ( 
	      );

my %gDirs = (
	     );

my %gHelpersInfo = ( 'df' => ['df'],
		     );

my %gHelpers = ();

# Used to indicate if init has been called before
my $gInitFlag = 0;

my $product = undef; # Initialized when c_getProductName is called

sub init {
    if ($gInitFlag) {
	return;
    }

    %gHelpers = &VMware::ExtHelpers::build_helpers(%gHelpersInfo);

    &VMware::ExtHelpers::verify_files(values(%gFiles));

    &VMware::ExtHelpers::verify_dirs(values(%gDirs));

    $gInitFlag = 1;
}

sub c_getProductName() {
    if (!defined($product)) {
	if ($^O =~ /MSWin32/i) {
            $product = "GSX"; 
        }
        else {
	    $product = &VMware::HConfig::GetProductName();
	    if (!defined($product)) {
	        Warning("Could not get product name");
	        return undef;
	    }
	    if ($product =~ /ESX/i) {
                $product = "ESX";
            }
	    elsif ($product =~ /GSX/i) {
                $product = "GSX";
            }
            else {
                Warning("Product not supported: $product");
                return undef;
            }
        }
    }

    return $product;
}

# Gets a file given a symbolic name. Delegates to product-specific function
# if necessary
sub c_getFile($) {
    my ($name) = @_;

    if (!$gInitFlag) {
	init();
    }

    if (defined($gFiles{$name})) {
	return ($gFiles{$name});
    } else {
	if (c_getProductName() eq "ESX") {
	    return &VMware::HConfig::Constant::c_getFile($name);
	}

	Warning("Requesting an invalid file $name ");
	return undef;
    }
}


# Gets a directory given a symbolic name. Delegates to product-specific function
# if necessary
sub c_getDir($) {
    my ($name) = @_;

    if (!$gInitFlag) {
	init();
    }

    if (defined($gDirs{$name})) {
	return ($gDirs{$name});
    } else {
	if (c_getProductName() eq "ESX") {
	    return &VMware::HConfig::Constant::c_getDir($name);
	}

	Warning("Requesting an invalid directory $name ");
	return undef;
    }
}


# Given a symbolic name, gets the incantation needed for a help. Delegates to
# product-specific function if necessary
sub c_getHelper {
    my ($name) = @_;


    if( !$gInitFlag ) {
	init();
    }

    my $product = c_getProductName();
    
    if( defined($gHelpers{$name}) ) {
	return($gHelpers{$name});
    } else { 
	if (c_getProductName() eq "ESX") {
	    return &VMware::HConfig::Constant::c_getHelper($name);
	}
	
	Warning("Requesting an invalid helper $name ");
	return undef;
    }
}


1;
