#!/usr/bin/perl -w

#############################################################
# Copyright 1998 VMware, Inc.  All rights reserved. -- VMware Confidential
#############################################################
#
# SSHost.pm
# 
# A class that is used to gather and manipulate information about the
# host being configured to run the Scalable Server.  Information
# includes PCI devices, LILO configuration, and memory size of host.

# Changes
# 1. pci devices should have separate parse and merge methods
# 2. makecpci should take a list of pci devs as args
# 3. add the ability to read the cmdline

package VMware::HConfig::SSHostRemote;
use strict; 

use Exporter   ();
use vars       qw($VERSION @ISA @EXPORT @EXPORT_OK %EXPORT_TAGS);

BEGIN {
    # set the version for version checking
    $VERSION     = 1.00;
#tmp
#    @ISA         = qw(Exporter VMware::HConfig::SSHost);
    @ISA         = qw(Exporter);
    @EXPORT_OK   = qw();
}

use vars qw();

#####################################################################
# Public Static Methods (indep. of each object                      #
#####################################################################

# The ctx parameter is optional for now.  Eventually it will be required
# and the others may go away.
sub new($$$$;$) {
	return(undef);
}

#####################################################################
# Public Methods                                                    #
#####################################################################

# Accessor functions

# Inherited from superclass
# sub getConfigDB() {
# sub getLocationsDB() {
# sub getPCIDeviceList($) {
# sub getDeviceNames($) {
# sub getNewlyNamedDevices() {
# sub getLILOConfig() {}
# sub getSNMPConfig() {}
# sub getSNMPEnable() {}
# sub getBootImageFiles() {}
# sub getInitrdImageFiles() {}
# sub getDirMapping() {}
# sub getKernelInfo() {}
# sub getKernelType() {}
# sub getKernelVersion() {}
# sub getSystemInfo() {}

# Gets the PCIDevice map.
sub getPCIDeviceMap() {
    return(undef);
}

# Inherited from superclass
# sub getVMSCSIDisks() {}
# sub getVMSCSITapes() {}
# sub getVMSCSICdroms() {}
# sub getVMSCSIAdapters() {}
# sub getVMNetAdapters() {}
# sub getVMNetAdapterPCIInfo($) {}
# sub getVMNetAdapterClustering($) {}
# sub getVMNetAdapterNICTeam($) {}
# sub getVMNetAdapterMAC($) {}
# sub getAvailNetAdapters() {
# sub getVMNetBondAdapters() {}
# sub getVMNetBondSlaves() {}
# sub getVMNetBondMAC() {}
# sub getVMNetTcpip() {
# sub getVMNetTcpipCfg() {

sub isVMNetTcpipSync() {
   return 0;
}

# Static function defined in superclass
# sub cmpVMNetTcpipSync() {

# Inherited from superclass
# sub getVMSCSIDiskByName($) {}
# sub getMFS($) {}
# sub getMFSByLogName($) {
# sub getMFSLookup($) {
# sub getVMnixModules() {}
# sub getVMKernelModules() {}
# sub getCurrentLabel() {}
# sub getAllMFSNames() {}
# sub getAllMFS() {}
# sub getTotalMemSize() {}
# sub getVmnixMemSize() {}
# sub getVmkMemSize() {
# sub getVMAvailMemSize() {}
# sub getMemSharingInfo() {}
# sub getVmkDumpPartitions() {}
# sub getNumCPUs() {}
# sub getRunningVmmWorlds() {

# Rescan the luns for a specified adapter
sub rescanLuns() {
    return(undef);
}

# Persist bindings for specified adapter
sub persist_bindings() {
    return(undef);
}

# Determines if the VMnix is running.  Returns true if it is.
sub isVMnix() {
    return(undef);
}

# Determines if the VMnix Module is running.  Required to run the
# vmkernel
sub isVMnixModule() {
    return(undef);
}

# Determines if the VMKernel is running.  
sub isVMKernel() {
    return(undef);
}

# Inherited from superclass
# sub lookupMountDevice($) {}
# sub lookupMount($) {}
#sub checkModules() {
#sub checkVmnixModules() {
#sub checkVmkModules() {

# Inherited from superclass
# sub dump {}

# sub addBondSlave($$) {
# sub removeBondSlave($$) {

# Remove a vmnic device from a NIC team determined by the bond
sub addRemoveBondSlave($$$) {
   return(undef);
}


# Given a LILOConfig object, writes out to lilo.conf
sub writeLILOConfig($) {
    return(undef);
}

# Executes LILO on the currently running system.
sub executeLILO() {
    return(undef);
}

# Writes the input text to the SNMP configuration file
sub writeSNMPConfig($) {
    return(undef);
}

# Determines if manual config is set for the system.
sub isManualConfig() {
    return(undef);
}

# Write to /etc/vmkmodules.conf.  Takes a label corresponding to the PCI Device
# list to write out.
sub writeVmkModules($) {
    return(undef);
}

# Write a line into the modules.conf file.
sub writeModulesConfLine($) {
    return(undef);
}

# Write a line into the modules.conf file.
# $initrdFile is optional.  Supply undef to have a default file name generated.
sub makeInitrdFile($) {
   return(undef);
}

# Commit the database.  
sub commitConfigDB() {
   return(undef);
}

# Reboot the machine.
sub rebootSystem() {
   return(undef);
}

# Halt the machine.
sub haltSystem() {
   return(undef);
}

#####################################################################
# Methods not intended for use by user                              #
#####################################################################

#####################################################################
# Methods Used to Support Remote Interface                          #
#####################################################################


sub loadAllData($) {
   return(undef);
}

sub getData($$) {
   return(undef);
}

sub getRemoteData() {
   return(undef);
}

sub dumpRemoteData() {
   return(undef);
}

sub getRemoteServer() {
   return(undef);
}

sub getCtx() {
   return(undef);
}

#####################################################################
# End of Methods Used to Support Remote Interface                   #
#####################################################################

#####################################################################
# Caching Support Functions                                         #
#####################################################################

# Inherited from superclass
# sub getCacheOptions() {}
# sub getDefaultCacheOptions() {}
# sub isCachedNever($) {}
# sub getCacheOption($) {}
# sub setCacheOptions($) {}
# sub setCacheOption($$) {}
# sub useDefaultCacheOptions() {}
# sub useNoCacheOptions() {}
# sub useOnceCacheOptions() {}
# sub flushCacheCallback {}

# Don't flush anything
sub flushCacheItem {
    return(0);
}

# Inherited from superclass
# sub flushCache {}

# The remote version of this function just does a test to see if the
# cached item is defined.  Default is that the items are cached and
# never invalidated.
sub needCacheUpdate($) {
    return(0);
}

sub getCacheSrcTime($) {
    return(0);
}


#####################################################################
# End of Caching Support Functions                                  #
#####################################################################

#####################################################################
# Missing Module Error Message Functions                            #
#####################################################################

# Functions used in superclass but not applicable to remote version.
#sub MissingModule_linux($) {
#sub MissingModule_scsi($) {
#sub MissingModule_eth($) {
#sub MissingModule_nfshaper($) {

#####################################################################
# Device Naming functions                                           #
#####################################################################

# Inherited from superclass
# sub findDeviceNames($) {

#   Writes out the device names of VMKernel-owned PCI devices into
#   "devnames.conf", for use with vmkchdev in order to set VMK
#   device names.  Given the device names and PCI device list
#   objects.
# Remote version: encapsulates data to be written & sends it.
#
# Args: ($devNames, $pciDevList)
#
# Returns: 0 if error, 1 upon success.
#
sub writeDevNamesConfig($$) {
   return(undef);
}


#####################################################################
# PCI Device Handling Functions                                     #
#####################################################################

# Inherited from superclass.
# sub findPCIDevices($) {

# Helper function that detects what PCI devices exist.
# Returns a list of PCI devices on success.
# Label is defined.
sub findPCIDevicesHelper($$) {
   return(undef);
}


# Builds a PCIDeviceList contining all the the devices found through
# probing.
sub findAllPCIDevicesProbe() {
   return(undef);
}

# Builds a PCIDeviceList consisting of all the devices that the host
# sees.  If the host is Linux, this list is a complete list.  If the
# host is VMnix, we have to use another method.
sub findHostPCIDevices() {
   return(undef);
   return(undef);
}

# Function in superclass not needed in remote version
#sub parse_proc_file() {
#sub parse_proc_bus_pci() {
#sub parse_safe_lspci() {
#sub parse_probe_lspci() {
#sub parse_probe_lspci2() {
#sub parse_lspci($) {
#sub parse_lspci_names($) {

# Functions inherited from the superclass
#sub removePCIDeviceConfigDB($$) {
#sub findPCIDeviceListInConfigDB($$$) {
#sub savePCIDeviceListInConfigDB($$$$) {

# Functions in superclass not needed in remote version
#sub regenerateConfigDB($$$) {
#sub reconcileConfigDB($$$) {

# Performs a check of the configuration database and removes any 
# keys that shouldn't be there.
#
# Stubbed out for the remote version.
sub cleanupPCIDevicesConfigDB($) {
    return(0);
}


# Functions used in superclass not needed in remote version.
#sub findPCIDevicesOwnershipByLILO($$) {

# Perform some sanity checks before returning the device list.
# These are not the best checks, but it's an imperfect world.
# Returns the number of warnings found. 0 otherwise.
# Turn on the fix flag to have the function change the ownership
# settings to match that of the current setup.
#
# These checks are not relevant on the remote side.
sub checkPCIDevicesWithCurrent($) {
    return(0);
}


#####################################################################
# END OF PCI Device Handling Functions                              #
#####################################################################

#####################################################################
# SCSI Adapter Decision Handling Functions                          #
#####################################################################

###############################
# Common SCSI Adapter Functions
###############################

# Returns the list of adapters as SCSIAdapter objects
sub findScsiAdapters($) {
   return(undef);
}


# Functions used in superclass not needed in remote version
#sub constructSCSIAdapters($) {
#sub constructSCSIDisks($) {
#sub readScsiPCIInfo($) {
#sub findWWPN() {

######################################
# End of Common SCSI Adapter Functions
######################################


#################################
# VMkernel SCSI Adapter Functions
#################################

# Functions used in superclass not needed in remote version
#sub findVmkScsiAdapterNames() {
#sub findVmkScsiAdapterPCIInfo($) {
#sub checkSharedScsi($) {

########################################
# End of vmkernel SCSI Adapter Functions
########################################

##############################
# VMnix SCSI Adapter Functions
##############################

# Functions used in superclass not needed in remote version
#sub findVmnixScsiAdapters() {
#sub findVmnixScsiAdapterNames() {
#sub findVmnixScsiAdapterPCIInfo($) {
#sub findVmnixScsiDisks($) {

#####################################
# End of VMnix SCSI Adapter Functions
#####################################

###################################
# VMnix CPQ Array Adapter Functions
###################################

# Functions used in superclass not needed in remote version
#sub findVmnixCpqArrayAdapters() {
#sub findVmnixCpqArrayAdapterNames() {
#sub findVmnixCpqArrayAdapterPCIInfo($) {
#sub findVmnixCpqArrayDisks($) {

##########################################
# End of VMnix CPQ Array Adapter Functions
##########################################

#################################
# VMnix DAC 960 Adapter Functions
#################################

# Functions used in superclass not needed in remote version
#sub findVmnixDac960Adapters() {
#sub findVmnixDac960AdapterNames() {
#sub findVmnixDac960AdapterPCIInfo($) {
#sub findVmnixDac960Disks($) {

########################################
# End of VMnix DAC 960 Adapter Functions
########################################

## Indicates if a device has partitions
#sub deviceHasPartitions($) {
#    my ($devFile) = @_;
#
#    my $command = c_getHelper('partition_list') . ' ' . shell_string($devFile);
#    local *FD;
#    my $hasPart = 0;
#    if( !open(FD, $command . " 2>/dev/null |") ) {
#	Warning("Cannot execute '$command': $!");
#	return(0);
#    }
#    while(<FD>) {
#	$hasPart = 1;
#    }
#    close(FD);
#    return( $hasPart );
#}

###############################
# SCSI Disk Locating functions
###############################

# Functions used in superclass not needed in remote version
#sub findVmkScsiDisks($) {
#sub filterScsiDisks($) {
#sub findVmkScsiDevTypes($$) {

#####################################
# End of SCSI Disk Locating functions
#####################################

#####################################################################
# END of SCSI Adapter Decision Handling Functions                   #
#####################################################################

# Finds Network controllers that are owned by the VM
# Returns a list of devices in the form eth0, eth1, etc. 
sub findVmkNetAdapters() {
   return(undef);
}

# Finds Network Bond controllers that are owned by the VM
sub findVmkNetBondAdapters() {
   return(undef);
}

# Looks in /proc/vmware/net to find all the tcpip instances
sub findVMNetTcpip() {
   return(undef);
}

# Gets the configured TCP/IP information for the vmkernel.
sub findVMNetTcpipCfg() {
   return(undef);
}

# Internal function to read TCPIP information
sub findVMNetTcpipInt($) {
   return(undef);
}

#####################################################################
# PCI Driver Decision Handling Functions                            #
#####################################################################

# Uses the driver map to get more complete information about our devices
# deviceMap argument is not used
sub findPCIDeviceDrivers($$) {
   return(undef);
}

#####################################################################
# END OF PCI Driver Decision Handling Functions                     #
#####################################################################

######################################################################
## Memory Handling Functions                                         #
######################################################################

# Finds the actual amount of memory on the machine in megabytes
sub findTotalMemSize($) {
   return(undef);
}

# Finds the amount of memory that the VMnix sees on the machine in megabytes
sub findVmnixMemSize($) {
   return(undef);
}

# Finds the amount of memory that the VMnix sees on the machine in megabytes
sub findVmkMemSize($) {
   return(undef);
}

# Find the amount of available memory for the VMs
sub findVMAvailMemSize($) {
   return(undef);
}

# Find the memory sharing statistics for the VMkernel
sub findMemSharingInfo() {
   return(undef);
}

# Functions used in superclass not needed in remote version
#sub readMemFromProc() {
#sub readMemFromVmwareProc() {

#####################################################################
# END of Memory Handling Functions                                  #
#####################################################################

#####################################################################
# Other Support Functions                                           #
#####################################################################
#
# Find the lilo.conf information
# 
# Note: In the remote version, the information is incomplete.  There is 
# not enough information to build a complete lilo.conf file.  We 
# export to the remote version only the parts of the lilo.conf file that 
# we care about.  It's the responsibility of the server side to make
# sure that lilo.conf is more or less valid.
#
sub findLILOConfig() {
   return(undef);
}

# Find the snmpd.conf information
sub findSNMPConfig() {
   return(undef);
}

# Determine whether SNMP is enabled or not
sub findSNMPEnable() {
   return(undef);
}


# Returns the config DB object.  
#
# XXX The config DB object should be remoted too but we won't do it for now.
# There are operations which need to be performed differently in a remote
# version of the config DB.
sub findConfigDB() {
   return(undef);
}

# Returns a hash containing the locations DB
sub findLocationsDB() {
   return(undef);
}

# Looks for available boot image files.  Looks only in the 
# /boot directory
sub findVMBootImageFiles() {
   return(undef);
}


# Looks for available initrd files.  Looks only in the 
# /boot directory
sub findVMInitrdImageFiles() {
   return(undef);
}

# Functions inherited from the superclass.
#sub findVmkDumpPartition {

# Builds a directory
sub findDirMapping() {
   return(undef);
}

# Functions used in superclass not needed in remote version
#sub parseMtabFile($) {
#sub _isVMnixKernel($) {

# Finds the name of the kernel
sub findKernelInfo() {
   return(undef);
}

## Reads the file /proc/cmdline and looks for the name of the label
## that was used in booting.
sub findCurrentLabel() {
   return(undef);
}

# Find all the MFS partitions on the SCSI disks that we have
sub findMFS() {
   return(undef);
}


# Returns an array of structures containing information about a VMnix module.  
# Format of structure:
#
# $modinfo->{MODULE} = name of module. ie vmnixmod
# $modinfo->{SIZE} = size of module
# $modinfo->{USED} = usage count. 0 means module is not in use and can be unloaded.
# $modinfo->{LOADED} = indicates of the module is loaded on the Console OS.
# $modinfo->{ALIASES} = aliases for module, if any, in /etc/modules.conf
sub findVMnixModules() {
   return(undef);
}

# Returns an array of structures containing information about a vmkernel module.
# Format of structure:
#
# $modinfo->{MODULE} = name of module. ie aic7xxx
# $modinfo->{SIZE} = size of module
# $modinfo->{ID} = ID of module
sub findVMKernelModules() {
   return(undef);
}

# Finds the number of CPUs
sub findNumCPUs() {
   return(undef);
}


# Finds the number of running Vmm worlds
sub findRunningVmmWorlds($) {
   return(undef);
}

# Functions used in superclass not needed in remote version
#sub findPCIDeviceMap() {
#sub canReadConfigDB() {
#sub checkDuplicateVmfsNames($) {

# Returns 0 if an error occurred.  1 on success.  -1 if no dump partition was 
# found.
sub setVmkDumpPartition() {
   return(undef);
}

# Unsets the vmkdump partition.  Returns 1 on success.  0 on failure.
sub unsetVmkDumpPartition() {
   return(undef);
}

# Checks if a license is needed to run VMware.  Returns (0, message) if a license is not 
# needed.  Otherwise return (0, message)
sub checkCanRunLicense() {
   return(undef);
}


# Registers a new serial number for a license
sub registerNewLicense() {
   return(undef);
}

sub getSwapInfo() {
   return(undef);
}

sub startSwapper {
   return(undef);
}

# Configures clustering support for a VMkernel NIC
sub setVMNetAdapterClustering {
   return(undef);
}

# Adds the TCP/IP setting
sub addVMNetTcpip {
   return(undef);
}

# Removes the TCP/IP setting
sub removeVMNetTcpip {
   return(undef);
}

# Removes the TCP/IP setting
sub setVMNetTcpip {
   return(undef);
}

sub waitForCmdStatus {
   return(undef);
}

#####################################################################
# Serverd Remote Request Support Functions                          #
# XXX These functions should be split into a remote module of its   #
#     own among other things.                                       #
#     Other copies of these functions exist at                      #
#     SSHostRemote.pm, RawDiskRemote.pm, MFSFileSystemRemote.pm     #
#     Index.pm                                                      #
#####################################################################

# The DOMAccess object returned must be explicitly freed by the caller
sub makeServerdRequest($) {
   return(undef);
}

# Sends a serverd request
sub sendServerdRequest($) {
   return(undef);
}

# Gets the return code of the response from serverd
sub getReturnCode($) {
   return(undef);
}

# Propagates warnings sent by vmserverd
sub ServerdWarning($) {
   return(undef);
}

# Sends a serverd request with a timeout parameter
sub doServerdRequestWithServer($$$) {
   return(undef);
}

# Sends a serverd request with a timeout parameter
sub doServerdRequestTimeout($$$$$$) {
   return(undef);
}

# Sends a serverd request
sub doServerdRequest($$$$$) {
   return(undef);
}

#####################################################################
# End of Serverd Remote Request Support Functions                   #
#####################################################################

1;
